//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
CCanvas canvas;
//+------------------------------------------------------------------+
#define _ToRadians(A) (A * (M_PI / 180.0))
//+------------------------------------------------------------------+
void Arrow(const int x, const int y, const ushort angle, const uchar size = 100)
{
	double ax[] = {0.0,  1.5, 1.0, 1.5},
	       ay[] = {0.0, -.75, 0.0, .75};
	int dx[ax.Size()], dy[ax.Size()];
	
	for (int c = 0; c < (int)ax.Size(); c++)
	{
        ax[c] *= size;
        ay[c] *= size;
        dx[c] = (int) ((ax[c] * cos(_ToRadians(angle))) + (ay[c] * sin(_ToRadians(angle)))) + x;
        dy[c] = (int) ((ax[c] *(-sin(_ToRadians(angle)))) + (ay[c] * cos(_ToRadians(angle)))) + y;
	}

	canvas.FillPolygon(dx, dy, ColorToARGB(clrGreen, 255));
	canvas.FillCircle(x, y, 5, ColorToARGB(clrRed, 255));
}
//+------------------------------------------------------------------+
int OnInit()
{	
	int px, py;
	
	px = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	py = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

	canvas.CreateBitmapLabel("BL", 0, 0, px, py, COLOR_FORMAT_ARGB_NORMALIZE);
	canvas.Erase(ColorToARGB(clrWhite, 255));
		
	Arrow(px / 2, py / 2, 60);

	canvas.Update(true);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	canvas.Destroy();
}
//+------------------------------------------------------------------+
