//+------------------------------------------------------------------+
//|                                                          Cct.mqh |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright                 "Copyright 2022, MetaQuotes Ltd."
#property link                      "https://www.mql5.com"
#property version                   "1.00"
  
#include                            <Object.mqh>

//#include                          <Math\Stat\stat.mqh>
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             types[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(types,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int TypeIndex,T &Type) { if(TypeIndex>=0 && TypeIndex<Cardinality()) { Type=types[TypeIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { types[ValueIndex]=Value; return(true); } return(false); }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CObjects                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) 
                                    { 
                                       //printf(__FUNCSIG__+" GOT index: "+IntegerToString(ElementIndex)+", cardinal: "+IntegerToString(Cardinality()));
                                       if(ElementIndex>=0 && ElementIndex<Cardinality()) 
                                       { 
                                          //printf(__FUNCSIG__+" index: "+IntegerToString(ElementIndex)+", cardinal: "+IntegerToString(Cardinality()));
                                          Element=elements[ElementIndex]; 
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          if(!IsIndexed||Index(Value)<0)
                                          { 
                                             elements[ValueIndex]=Value; 
                                             return(true); 
                                          }
                                          else
                                          { 
                                             printf(__FUNCSIG__+" value already exists. "); 
                                          } 
                                       }
                                       else
                                       { 
                                          if(ValueIndex>=0 && Cardinality()<ValueIndex+1 && ValueIndex<INT_MAX)
                                          {
                                             if(Cardinality(ValueIndex+1))
                                             {
                                                elements[ValueIndex]=Value; 
                                                return(true); 
                                             }
                                          }
                                          else
                                          {
                                             printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CObjects(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CObjects(void) {};
   };
//+------------------------------------------------------------------+
//| MORPHISM CLASS                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CMorphism
   {
      protected:
      
      int                           domain_index;
      int                           codomain_index;
      
      public:
      
      CObjects<TD>                   domain;
      CObjects<TC>                   codomain;
      
      double                        morphing[];
      
      int                           Domain(){ return(domain_index); };
      bool                          Domain(int DomainIndex) 
                                    { 
                                       if(DomainIndex>=0 && DomainIndex<domain.Cardinality()) 
                                       { 
                                          domain_index=DomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(DomainIndex>=0 && domain.Cardinality()==0 && DomainIndex<INT_MAX)
                                          { 
                                             domain.Cardinality(DomainIndex+1); domain_index=DomainIndex; return(true); 
                                          } 
                                          else if(DomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(DomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(domain.Cardinality())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      int                           Codomain(){ return(codomain_index); };
      bool                          Codomain(int CodomainIndex) 
                                    { 
                                       if(CodomainIndex>=0 && CodomainIndex<codomain.Cardinality()) 
                                       { 
                                          codomain_index=CodomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(CodomainIndex>=0 && codomain.Cardinality()==0 && CodomainIndex<INT_MAX)
                                          { 
                                             codomain.Cardinality(CodomainIndex+1); codomain_index=CodomainIndex; return(true); 
                                          } 
                                          else if(CodomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(CodomainIndex)+" out of bounds for codomain cardinal: "+IntegerToString(codomain.Cardinality())+". "); 
                                          } 
                                       } 
                                       
                                       return(false); 
                                    }
      
                                    template <typename TDD,typename TDC>
      bool                          Morph(CObjects<TDD> &D,CObjects<TDC> &C,int DomainIndex,int CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<D.Cardinality())
                                       {
                                          domain_index=DomainIndex;
                                          codomain_index=CodomainIndex;
                                          
                                          domain=D;
                                          codomain=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
      //
      void                          Let()
                                    {
                                       this.codomain.Cardinality(0);
                                       this.domain.Cardinality(0);
                                       this.Codomain(-1);
                                       this.Domain(-1);
                                    };
      
                                    CMorphism(void){ domain_index=-1; codomain_index=-1; };
                                    ~CMorphism(void){};
   };
//+------------------------------------------------------------------+
//| HOMO-MORPHISM CLASS                                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CHomomorphism                 : public CObject
   {
      protected:
      
      int                           morphisms;
      
      public:
      
      CObjects<TD>                   domain;
      CObjects<TC>                   codomain;
      
      CMorphism<TD,TC>              morphism[];
      
      int                           Morphisms() { return(morphisms); }
      bool                          Morphisms(int Value) { if(Value>=0 && Value<INT_MAX) { morphisms=Value; ArrayResize(morphism,morphisms); return(true); } return(false); }
      
      bool                          Get(int MorphismIndex,CMorphism<TD,TC> &Morphism) { if(MorphismIndex>=0 && MorphismIndex<Morphisms()) { Morphism=morphism[MorphismIndex]; Morphism.domain=domain; Morphism.codomain=codomain; Morphism.Domain(morphism[MorphismIndex].Domain()); Morphism.Codomain(morphism[MorphismIndex].Codomain()); return(true); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Set(int ValueIndex,CMorphism<TDD,TDC> &Value)
                                    {
                                       if
                                       (
                                       (string(typename(TD))!=string(typename(TDD)))
                                       ||
                                       (string(typename(TC))!=string(typename(TDC)))
                                       )
                                       {
                                          printf(__FUNCSIG__+" mismatched domain and/or codomain... ");
                                          return(false);
                                       }
                                       // 
                                       int _index=Index(Value);
                                       //
                                       if(_index==-1)
                                       {
                                          if(ValueIndex>=0 && ValueIndex<Morphisms())
                                          {
                                             morphism[ValueIndex]=Value;
                                             
                                             return(true);
                                          }
                                          else if(ValueIndex>=0 && ValueIndex<INT_MAX)
                                          {
                                             if(Morphisms(ValueIndex+1))
                                             {
                                                morphism[ValueIndex]=Value;
                                                
                                                return(true);
                                             }
                                          }
                                       }
                                       
                                       return(false); 
                                    };
      
      void                          Let()
                                    {
                                       this.Morphisms(0);
                                       this.domain.Cardinality(0);
                                       this.codomain.Cardinality(0);
                                    };
      
      int                           Index(CMorphism<TD,TC> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int m=0; m<Morphisms(); m++)
                                       {
                                          if(MorphismMatch(Value,morphism[m]))
                                          {
                                             _index=m; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CHomomorphism(void){  Morphisms(0); };
                                    ~CHomomorphism(void){};
   };
//+------------------------------------------------------------------+
//| CATEGORY CLASS                                                   |
//+------------------------------------------------------------------+
class CCategory
   {
      protected:
      
      int                           domains;
      int                           homomorphisms;
      
      public:
      
      CObjects<string>               domain[];
      CHomomorphism<string,string>  homomorphism[];
      
      int                           Domains() { return(domains); }
      bool                          Domains(int Value) { if(Value>=0 && Value<INT_MAX-1) { domains=Value; ArrayResize(domain,domains); return(true); } return(false); }
      
      int                           Homomorphisms() { return(homomorphisms); }
      bool                          Homomorphisms(int Value) { if(Value>=0 && Value<INT_MAX) { homomorphisms=Value; ArrayResize(homomorphism,homomorphisms); return(true); } return(false); }
      
      bool                          GetHomomorphism(int HomomorphismIndex,CHomomorphism<string,string> &Homomorphism) { if(HomomorphismIndex>=0 && HomomorphismIndex<Homomorphisms()) { Homomorphism=homomorphism[HomomorphismIndex]; return(true); } return(false); }
      
      bool                          SetHomomorphism(int ValueIndex,CHomomorphism<string,string> &Value)
                                    {
                                       if(IndexHomomorphism(Value)==-1 && ValueIndex>=0)
                                       {
                                          if
                                          (
                                          ValueIndex<Homomorphisms()
                                          )
                                          {
                                             homomorphism[ValueIndex]=Value;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=Homomorphisms() && Homomorphisms(Homomorphisms()+1))
                                          )
                                          {
                                             homomorphism[Homomorphisms()-1]=Value;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
      
      int                           IndexHomomorphism(CHomomorphism<string,string> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Homomorphisms(); d++)
                                       {
                                          if(HomomorphismMatch(Value,homomorphism[d]))
                                          {
                                             _index=d; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      bool                          GetDomain(int DomainIndex,CObjects<string> &Domain) { if(DomainIndex>=0 && DomainIndex<Domains()) { Domain=domain[DomainIndex]; return(true); } return(false); }
      
                                    template <typename T>
      bool                          SetDomain(int ValueIndex,CObjects<T> &Value)
                                    {
                                       CObjects<string> _value;
                                       if(_value.Cardinality(Value.Cardinality()))
                                       {
                                          for(int c=0;c<_value.Cardinality();c++)
                                          {
                                             CElement<T> _e_t;
                                             CElement<string> _e_s;
                                             
                                             if(Value.Get(c,_e_t))
                                             {
                                                if(_e_s.Cardinality(_e_t.Cardinality()))
                                                {
                                                for(int cc=0;cc<_e_t.Cardinality();cc++)
                                                {
                                                   if(string(typename(T))=="datetime")
                                                   {
                                                      T _date;
                                                      if(_e_t.Get(cc,_date)){ _e_s.Set(cc,TimeToString(datetime(_date))); }
                                                   }
                                                   else if(string(typename(T))=="string")
                                                   {
                                                      T _string;
                                                      if(_e_t.Get(cc,_string)){ _e_s.Set(cc,_string); }
                                                   }
                                                   else if(string(typename(T))=="double"||string(typename(T))=="float")
                                                   {
                                                      T _double;
                                                      if(_e_t.Get(cc,_double)){ _e_s.Set(cc,DoubleToString(double(_double))); }
                                                   }
                                                   else //if(string(typename(T))=="int")
                                                   {
                                                      T _int;
                                                      if(_e_t.Get(cc,_int)){ _e_s.Set(cc,IntegerToString(int(_int))); }
                                                   }
                                                }
                                                
                                                if(_value.Set(c,_e_s))
                                                {
                                                   if(c==_value.Cardinality()-1)
                                                   {
                                                      if(IndexDomain(_value)==-1 && ValueIndex>=0)
                                                      {
                                                         if
                                                         (
                                                         ValueIndex<Domains()
                                                         )
                                                         {
                                                            domain[ValueIndex]=_value;
                                                            return(true);
                                                         }
                                                         else if
                                                         (
                                                         (ValueIndex>=Domains() && Domains(Domains()+1))
                                                         )
                                                         {
                                                            domain[Domains()-1]=_value;
                                                            return(true);
                                                         }
                                                      }
                                                   }
                                                }
                                                }
                                             }
                                          }
                                       }
                                       
                                       //
                                       return(false);
                                    };
      
      int                           IndexDomain(CObjects<string> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Domains(); d++)
                                       {
                                          if(DomainMatch(Value,domain[d]))
                                          {
                                             _index=d; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      void                          Let()
                                    {
                                       this.Domains(0);
                                       this.Homomorphisms(0);
                                    };
      
                                    CCategory()
                                    {  
                                    };
                                    ~CCategory()
                                    { 
                                    };
   };
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         TA _a;TB _b;
         if(A.Get(r,_a) && B.Get(r,_b) && _a!=_b)
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CObjects<TA> &A,CObjects<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Morphism Match function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool MorphismMatch(CMorphism<TD,TC> &A,CMorphism<TD,TC> &B)
   {
      bool _matched=true;
      
      if(A.Domain()!=B.Domain()||A.Codomain()!=B.Codomain())
      {
         _matched=false;return(_matched);
      }
      
      if(!DomainMatch(A.domain,B.domain)||!DomainMatch(A.codomain,B.codomain))
      {
         _matched=false;return(_matched);
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Homomorphism Match function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool HomomorphismMatch(CHomomorphism<TD,TC> &A,CHomomorphism<TD,TC> &B)
   {
      if(A.Morphisms()!=B.Morphisms())
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int m=0; m<A.Morphisms(); m++)
      {
         CMorphism<TD,TC> _a;
         CMorphism<TD,TC> _b;
         
         if(A.Get(m,_a) && B.Get(m,_b) && !MorphismMatch(_a,_b))
         {
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            T _date;
            if(E.Get(r,_date)){ _element+=TimeToString(datetime(_date)); }
         }
         else if(string(typename(T))=="string")
         {
            T _string;
            if(E.Get(r,_string)){ _element+=string(_string); }
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            T _double;
            if(E.Get(r,_double)){ _element+=DoubleToString(double(_double)); }
         }
         else //if(string(typename(T))=="int")
         {
            T _int;
            if(E.Get(r,_int)){ _element+=IntegerToString(int(_int)); }
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CObjects<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
