//+------------------------------------------------------------------+
//|                                                     SignalCT.mqh |
//|                   Copyright 2009-2013, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <ct_21.mqh>
#include <Math\Alglib\dataanalysis.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
#define __CLASSES 3
#define __BULLISH __CLASSES-1
#define __WHIPSAW 1
#define __BEARISH 0
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on 'Category Theory' Transformer article 21  |
//| Type=SignalAdvanced                                              |
//| Name=CategoryTheory                                              |
//| ShortName=CT                                                     |
//| Class=CSignalCT                                                  |
//| Page=signal_ct                                                   |
//| Parameter=Data,int,21,Data Points                                |
//| Parameter=Independents,int,5,Independent Variables               |
//| Parameter=Regulizer,int,25,Regulizer Points Threshold            |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalCT.                                                 |
//| Appointment: Class of generator of trade signals based on        |
//|               'Category Theory' Transformer article 21           |
//| Derives from class CExpertSignal.                                |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalCT : public CExpertSignal
  {
protected:
   //--- adjusted parameters
   int                     m_data;
   int                     m_independent;
   int                     m_regularizer;
   //

public:
   //--- methods of setting adjustable parameters
   void                    Data(int value)                        { m_data=value;               }
   void                    Independents(int value)                { m_independent=value;        }
   void                    Regulizer(int value)                   { m_regularizer=value;          }
   
   
   
   //--- method of verification of settings
   virtual bool            ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool            InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int             LongCondition(void);
   virtual int             ShortCondition(void);
   
   virtual void            Refresh(int DataPoints=1);// override;
   
   virtual double          GetDirection();// override;
   //---
                           CSignalCT(void);
                           ~CSignalCT(void);
   //--- methods of initialization of protected data
   
   CElement<string>        m_e_s;      //simple element
   CElement<string>        m_e_c;      //compound element
   
   CObjects<string>        m_o_s;      //simple object
   CObjects<string>        m_o_c;      //compound object
   
   
   CLDA                    m_lda;
   
   
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalCT::CSignalCT(void)
  {
//--- initialization of protected data
      m_used_series=USE_SERIES_TIME+USE_SERIES_SPREAD+USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
      
      m_o_s.Let(); m_o_s.Cardinality(1);
      m_o_c.Let(); m_o_c.Cardinality(1);
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalCT::~CSignalCT(void)
  {
  
  }
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalCT::ValidationSettings(void)
  {
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
      
//--- validation settings of additional filters
   if(PeriodSeconds(PERIOD_W1)<=PeriodSeconds(m_period)){
      printf(__FUNCSIG__+" time frame should be less than weekly. ");
      return(false);}
      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalCT::InitIndicators(CIndicators *indicators)
  {
//--- check pointer
   if(indicators==NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
      
      
      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalCT::LongCondition(void)
  {
      int result=0;
      
      double _direction=GetDirection();
      //printf(__FUNCSIG__+" direction: "+DoubleToString(_direction,8));
      
      if(_direction<0)
      {
         result=0;
      }
      else if(_direction>0)
      {
         result=100;
      }
      
      return(result);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalCT::ShortCondition(void)
  {
      int result=0;
      
      double _direction=GetDirection();
      //printf(__FUNCSIG__+" direction: "+DoubleToString(_direction,8));
      
      if(_direction>0)
      {
         result=0;
      }
      else if(_direction<0)
      {
         result=100;
      }
      
      return(result);
  }
//+------------------------------------------------------------------+
//| Refresh function to update objects.                              |
//+------------------------------------------------------------------+
void CSignalCT::Refresh(int DataPoints=1)
   {
      m_time.Refresh(-1);
      m_close.Refresh(-1);
      
      for(int v=0;v<DataPoints;v++)
      {
         m_e_s.Let(); m_e_s.Cardinality(2);
         m_e_c.Let(); m_e_c.Cardinality(m_independent+1);
         
         m_e_s.Set(0,TimeToString(m_time.GetData(v)));
         m_e_c.Set(0,TimeToString(m_time.GetData(v)));
      
         double _s_unit=0.0;
         //set independent variables..
         for(int vv=0;vv<m_independent;vv++)
         {
            double _c_unit=m_close.GetData(StartIndex()+v+vv+m_independent);
            
            m_e_c.Set(vv+1,DoubleToString(_c_unit));
         }
         
         m_o_c.Set(0,m_e_c);
         
         //get dependent variable, the MA..
         for(int vv=v;vv<v+m_independent;vv++)
         {
            _s_unit+=m_close.GetData(StartIndex()+vv);
         }
         
         _s_unit/=m_independent;
         
         m_e_s.Set(1,DoubleToString(_s_unit));
         
         m_o_s.Set(0,m_e_s);
      }
   }
//+------------------------------------------------------------------+
//| Get Direction function from implied naturality square.           |
//+------------------------------------------------------------------+
double CSignalCT::GetDirection()
   {
      double _da=0.0;
      
      int _info=0;
      CMatrixDouble _w,_xy,_z;
      _xy.Resize(m_data,m_independent+1);
      
      double _point=0.00001;
      if(StringFind(m_symbol.Name(),"JPY")>=0){ _point=0.001; }
      
      for(int v=0;v<m_data;v++)
      {
         Refresh(v+1);
         
         m_e_s.Let(); m_e_s.Cardinality(2);
         m_e_c.Let(); m_e_c.Cardinality(m_independent+1);
         
         m_o_c.Get(0,m_e_c);
            
         double _ma=0.0,_lag_ma=0.0;
         //set independent variables..
         for(int vv=0;vv<m_independent;vv++)
         {
            string _c="";
            m_e_c.Get(vv+1,_c);
            double _c_value=StringToDouble(_c);
            _xy.Set(v,vv,_c_value);
            //lagging regulizing MA..
            _lag_ma+=_c_value;
         }
         
         _lag_ma/=m_independent;
         
         //get dependent variable, the MA..
         string _s="";
         m_o_s.Get(0,m_e_s);
         m_e_s.Get(1,_s);
         _ma=StringToDouble(_s);
         
         //training classification
         _xy.Set(v,m_independent,(fabs(_ma-_lag_ma)<=m_regularizer*_point?1:(_ma-_lag_ma>0.0?2:0)));
      }
      
      m_lda.FisherLDAN(_xy,m_data,m_independent,__CLASSES,_info,_w);
      
      if(_info>0)
      {
         double _centroids[__CLASSES],_unknown_centroid=0.0; ArrayInitialize(_centroids,0.0);
         
         _z.Resize(1,m_independent+1);
         
         m_o_c.Get(0,m_e_c);
         
         for(int vv=0;vv<m_independent;vv++)
         {
            string _c="";
            m_e_c.Get(vv+1,_c);
            
            double _c_value=StringToDouble(_c);
            _z.Set(0,vv,_c_value);
         }
         
         for(int v=0;v<m_data;v++)
         {
            for(int vv=0;vv<m_independent;vv++)
            {
               _centroids[int(_xy[v][m_independent])]+= (_w[0][vv]*_xy[v][vv]);
            }
         }
         
         // best vector is the first 
         for(int vv=0;vv<m_independent;vv++){ _unknown_centroid+= (_w[0][vv]*_z[0][vv]); }
         
         if(fabs(_centroids[__BULLISH]-_unknown_centroid)<fabs(_centroids[__BEARISH]-_unknown_centroid))
         {
            _da=(1.0-(fabs(_centroids[__BULLISH]-_unknown_centroid)/(fabs(_centroids[__BULLISH]-_unknown_centroid)+fabs(_centroids[__WHIPSAW]-_unknown_centroid)+fabs(_centroids[__BEARISH]-_unknown_centroid))));
         }
         else if(fabs(_centroids[__BEARISH]-_unknown_centroid)<fabs(_centroids[__BULLISH]-_unknown_centroid))
         {
            _da=-1.0*(1.0-(fabs(_centroids[__BEARISH]-_unknown_centroid)/(fabs(_centroids[__BULLISH]-_unknown_centroid)+fabs(_centroids[__WHIPSAW]-_unknown_centroid)+fabs(_centroids[__BEARISH]-_unknown_centroid))));
         }
      }
      else
      {
         printf(__FUNCSIG__+" "+m_symbol.Name()+" LDA init failed! ");
         
         if(_info==-4){ printf(__FUNCSIG__+" internal EVD subroutine hasn't converged "); }
         else if(_info==-2){ printf(__FUNCSIG__+" there is a point with class number outside of [0..NClasses-1] "); }
         else if(_info==-1){ printf(__FUNCSIG__+" incorrect parameters was passed  either: NPoints<0, or NVars<1, or NClasses<2) "); }
      }
      
      return(_da);
   }
//+------------------------------------------------------------------+
