//+------------------------------------------------------------------+
//|                                                          Cct.mqh |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright                 "Copyright 2022, MetaQuotes Ltd."
#property link                      "https://www.mql5.com"
#property version                   "1.00"
#include                            <Math\Stat\stat.mqh>
#include                            <Math\Alglib\alglib.mqh>
#include                            <Math\Alglib\dataanalysis.mqh>
  
#include                            <Object.mqh>

//#include                          <Math\Stat\stat.mqh>
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             types[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(types,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int TypeIndex,T &Type) { if(TypeIndex>=0 && TypeIndex<Cardinality()) { Type=types[TypeIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { types[ValueIndex]=Value; return(true); } return(false); }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CDomain                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) 
                                    { 
                                       //printf(__FUNCSIG__+" GOT index: "+IntegerToString(ElementIndex)+", cardinal: "+IntegerToString(Cardinality()));
                                       if(ElementIndex>=0 && ElementIndex<Cardinality()) 
                                       { 
                                          //printf(__FUNCSIG__+" index: "+IntegerToString(ElementIndex)+", cardinal: "+IntegerToString(Cardinality()));
                                          Element=elements[ElementIndex]; 
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          if(!IsIndexed||Index(Value)<0)
                                          { 
                                             elements[ValueIndex]=Value; 
                                             return(true); 
                                          }
                                          else
                                          { 
                                             printf(__FUNCSIG__+" value already exists. "); 
                                          } 
                                       }
                                       else
                                       { 
                                          if(ValueIndex>=0 && Cardinality()<ValueIndex+1 && ValueIndex<INT_MAX)
                                          {
                                             if(Cardinality(ValueIndex+1))
                                             {
                                                elements[ValueIndex]=Value; 
                                                return(true); 
                                             }
                                          }
                                          else
                                          {
                                             printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CDomain(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CDomain(void) {};
   };
//+------------------------------------------------------------------+
//| MORPHISM CLASS                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CMorphism
   {
      protected:
      
      int                           domain_index;
      int                           codomain_index;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      double                        morphing[];
      
      int                           Domain(){ return(domain_index); };
      bool                          Domain(int DomainIndex) 
                                    { 
                                       if(DomainIndex>=0 && DomainIndex<domain.Cardinality()) 
                                       { 
                                          domain_index=DomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(DomainIndex>=0 && domain.Cardinality()==0 && DomainIndex<INT_MAX)
                                          { 
                                             domain.Cardinality(DomainIndex+1); domain_index=DomainIndex; return(true); 
                                          } 
                                          else if(DomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(DomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(domain.Cardinality())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      int                           Codomain(){ return(codomain_index); };
      bool                          Codomain(int CodomainIndex) 
                                    { 
                                       if(CodomainIndex>=0 && CodomainIndex<codomain.Cardinality()) 
                                       { 
                                          codomain_index=CodomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(CodomainIndex>=0 && codomain.Cardinality()==0 && CodomainIndex<INT_MAX)
                                          { 
                                             codomain.Cardinality(CodomainIndex+1); codomain_index=CodomainIndex; return(true); 
                                          } 
                                          else if(CodomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(CodomainIndex)+" out of bounds for codomain cardinal: "+IntegerToString(codomain.Cardinality())+". "); 
                                          } 
                                       } 
                                       
                                       return(false); 
                                    }
      
                                    template <typename TDD,typename TDC>
      bool                          Morph(CDomain<TDD> &D,CDomain<TDC> &C,int DomainIndex,int CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<D.Cardinality())
                                       {
                                          domain_index=DomainIndex;
                                          codomain_index=CodomainIndex;
                                          
                                          domain=D;
                                          codomain=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
      //
      void                          Let()
                                    {
                                       this.codomain.Cardinality(0);
                                       this.domain.Cardinality(0);
                                       this.Codomain(-1);
                                       this.Domain(-1);
                                    };
      
                                    CMorphism(void){ domain_index=-1; codomain_index=-1; };
                                    ~CMorphism(void){};
   };
//+------------------------------------------------------------------+
//| HOMO-MORPHISM CLASS                                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CHomomorphism                 : public CObject
   {
      protected:
      
      int                           morphisms;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      CMorphism<TD,TC>              morphism[];
      
      int                           Morphisms() { return(morphisms); }
      bool                          Morphisms(int Value) { if(Value>=0 && Value<INT_MAX) { morphisms=Value; ArrayResize(morphism,morphisms); return(true); } return(false); }
      
      bool                          Get(int MorphismIndex,CMorphism<TD,TC> &Morphism) { if(MorphismIndex>=0 && MorphismIndex<Morphisms()) { Morphism=morphism[MorphismIndex]; Morphism.domain=domain; Morphism.codomain=codomain; Morphism.Domain(morphism[MorphismIndex].Domain()); Morphism.Codomain(morphism[MorphismIndex].Codomain()); return(true); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Set(int ValueIndex,CMorphism<TDD,TDC> &Value)
                                    {
                                       if
                                       (
                                       (string(typename(TD))!=string(typename(TDD)))
                                       ||
                                       (string(typename(TC))!=string(typename(TDC)))
                                       )
                                       {
                                          printf(__FUNCSIG__+" mismatched domain and/or codomain... ");
                                          return(false);
                                       }
                                       // 
                                       int _index=Index(Value);
                                       //
                                       if(_index==-1)
                                       {
                                          if(ValueIndex>=0 && ValueIndex<Morphisms())
                                          {
                                             morphism[ValueIndex]=Value;
                                             
                                             return(true);
                                          }
                                          else if(ValueIndex>=0 && ValueIndex<INT_MAX)
                                          {
                                             if(Morphisms(ValueIndex+1))
                                             {
                                                morphism[ValueIndex]=Value;
                                                
                                                return(true);
                                             }
                                          }
                                       }
                                       
                                       return(false); 
                                    };
      
      void                          Let()
                                    {
                                       this.Morphisms(0);
                                       this.domain.Cardinality(0);
                                       this.codomain.Cardinality(0);
                                    };
      
      int                           Index(CMorphism<TD,TC> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int m=0; m<Morphisms(); m++)
                                       {
                                          if(MorphismMatch(Value,morphism[m]))
                                          {
                                             _index=m; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CHomomorphism(void){  Morphisms(0); };
                                    ~CHomomorphism(void){};
   };
//+------------------------------------------------------------------+
//| CATEGORY CLASS                                                   |
//+------------------------------------------------------------------+
class CCategory
   {
      protected:
      
      int                           domains;
      int                           homomorphisms;
      
      public:
      
      CDomain<string>               domain[];
      CHomomorphism<string,string>  homomorphism[];
      
      int                           Domains() { return(domains); }
      bool                          Domains(int Value) { if(Value>=0 && Value<INT_MAX) { domains=Value; ArrayResize(domain,domains); return(true); } return(false); }
      
      int                           Homomorphisms() { return(homomorphisms); }
      bool                          Homomorphisms(int Value) { if(Value>=0 && Value<INT_MAX) { homomorphisms=Value; ArrayResize(homomorphism,homomorphisms); return(true); } return(false); }
      
      bool                          GetHomomorphism(int HomomorphismIndex,CHomomorphism<string,string> &Homomorphism) { if(HomomorphismIndex>=0 && HomomorphismIndex<Homomorphisms()) { Homomorphism=homomorphism[HomomorphismIndex]; return(true); } return(false); }
      
      bool                          SetHomomorphism(int ValueIndex,CHomomorphism<string,string> &Value)
                                    {
                                       if(IndexHomomorphism(Value)==-1 && ValueIndex>=0)
                                       {
                                          if
                                          (
                                          ValueIndex<Homomorphisms()
                                          )
                                          {
                                             homomorphism[ValueIndex]=Value;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=Homomorphisms() && Homomorphisms(Homomorphisms()+1))
                                          )
                                          {
                                             homomorphism[Homomorphisms()-1]=Value;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
      
      int                           IndexHomomorphism(CHomomorphism<string,string> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Homomorphisms(); d++)
                                       {
                                          if(HomomorphismMatch(Value,homomorphism[d]))
                                          {
                                             _index=d; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      bool                          GetDomain(int DomainIndex,CDomain<string> &Domain) { if(DomainIndex>=0 && DomainIndex<Domains()) { Domain=domain[DomainIndex]; return(true); } return(false); }
      
                                    template <typename T>
      bool                          SetDomain(int ValueIndex,CDomain<T> &Value)
                                    {
                                       CDomain<string> _value;
                                       if(_value.Cardinality(Value.Cardinality()))
                                       {
                                          for(int c=0;c<_value.Cardinality();c++)
                                          {
                                             CElement<T> _e_t;
                                             CElement<string> _e_s;
                                             
                                             if(Value.Get(c,_e_t))
                                             {
                                                if(_e_s.Cardinality(_e_t.Cardinality()))
                                                {
                                                for(int cc=0;cc<_e_t.Cardinality();cc++)
                                                {
                                                   if(string(typename(T))=="datetime")
                                                   {
                                                      T _date;
                                                      if(_e_t.Get(cc,_date)){ _e_s.Set(cc,TimeToString(datetime(_date))); }
                                                   }
                                                   else if(string(typename(T))=="string")
                                                   {
                                                      T _string;
                                                      if(_e_t.Get(cc,_string)){ _e_s.Set(cc,_string); }
                                                   }
                                                   else if(string(typename(T))=="double"||string(typename(T))=="float")
                                                   {
                                                      T _double;
                                                      if(_e_t.Get(cc,_double)){ _e_s.Set(cc,DoubleToString(double(_double))); }
                                                   }
                                                   else //if(string(typename(T))=="int")
                                                   {
                                                      T _int;
                                                      if(_e_t.Get(cc,_int)){ _e_s.Set(cc,IntegerToString(int(_int))); }
                                                   }
                                                }
                                                
                                                if(_value.Set(c,_e_s))
                                                {
                                                   if(c==_value.Cardinality()-1)
                                                   {
                                                      if(IndexDomain(_value)==-1 && ValueIndex>=0)
                                                      {
                                                         if
                                                         (
                                                         ValueIndex<Domains()
                                                         )
                                                         {
                                                            domain[ValueIndex]=_value;
                                                            return(true);
                                                         }
                                                         else if
                                                         (
                                                         (ValueIndex>=Domains() && Domains(Domains()+1))
                                                         )
                                                         {
                                                            domain[Domains()-1]=_value;
                                                            return(true);
                                                         }
                                                      }
                                                   }
                                                }
                                                }
                                             }
                                          }
                                       }
                                       
                                       //
                                       return(false);
                                    };
      
      int                           IndexDomain(CDomain<string> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Domains(); d++)
                                       {
                                          if(DomainMatch(Value,domain[d]))
                                          {
                                             _index=d; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      void                          Let()
                                    {
                                       this.Domains(0);
                                       this.Homomorphisms(0);
                                    };
      
                                    CCategory()
                                    {  
                                    };
                                    ~CCategory()
                                    { 
                                    };
   };
   
//+------------------------------------------------------------------+
//| FUNCTOR STRUCT                                                   |
//+------------------------------------------------------------------+
struct SFunctor
  {
      double                        weight[];
      
                                    SFunctor(){ ArrayFree(weight); };
                                    ~SFunctor(){};
  };
//+------------------------------------------------------------------+
//| FUNCTOR CLASS                                                    |
//+------------------------------------------------------------------+
class CFunctor                      : public CObject
   {
      protected:
      
      int                           domain_indices;
      int                           homomorphism_indices;
      
      public:
      
      CCategory                     domain_category;
      CCategory                     codomain_category;
      
      double                        functoring_domains[];
      SFunctor                      functoring_homomorphisms[];
      
      int                           domain_domain_index[];
      int                           codomain_domain_index[];
      
      int                           domain_homomorphism_index[];
      int                           codomain_homomorphism_index[];
      
      //
      
      int                           GetDomainDomainIndex(int DomainDomainIndex) { if(DomainDomainIndex>=0 && DomainDomainIndex<DomainIndices()) { return(domain_domain_index[DomainDomainIndex]); } return(-1); }
      bool                          SetDomainDomainIndex(int DomainDomainIndex,int ValueIndex)
                                    {
                                       if(IndexDomain(ValueIndex)==-1 && ValueIndex>=0 && DomainDomainIndex>=0 && DomainDomainIndex<DomainIndices())
                                       {
                                          if
                                          (
                                          ValueIndex<DomainIndices()
                                          )
                                          {
                                             domain_domain_index[DomainDomainIndex]=ValueIndex;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=DomainIndices() && DomainIndices(DomainIndices()+1))
                                          )
                                          {
                                             domain_domain_index[DomainIndices()-1]=ValueIndex;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
      
      int                           GetCodomainDomainIndex(int CodomainDomainIndex) { if(CodomainDomainIndex>=0 && CodomainDomainIndex<DomainIndices()) { return(codomain_domain_index[CodomainDomainIndex]); } return(-1); }
      bool                          SetCodomainDomainIndex(int CodomainDomainIndex,int ValueIndex)
                                    {
                                       if(IndexDomain(ValueIndex)==-1 && ValueIndex>=0 && CodomainDomainIndex>=0 && CodomainDomainIndex<DomainIndices())
                                       {
                                          if
                                          (
                                          ValueIndex<DomainIndices()
                                          )
                                          {
                                             codomain_domain_index[CodomainDomainIndex]=ValueIndex;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=DomainIndices() && DomainIndices(DomainIndices()+1))
                                          )
                                          {
                                             codomain_domain_index[DomainIndices()-1]=ValueIndex;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
      
      int                           IndexDomain(int ValueIndex)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<DomainIndices(); d++)
                                       {
                                          if(d==ValueIndex)
                                          {
                                             _index=d; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      int                           GetDomainHomomorphismIndex(int DomainHomomorphismIndex) { if(DomainHomomorphismIndex>=0 && DomainHomomorphismIndex<HomomorphismIndices()) { return(domain_homomorphism_index[DomainHomomorphismIndex]); } return(-1); }
      bool                          SetDomainHomomorphismIndex(int DomainHomomorphismIndex,int ValueIndex)
                                    {
                                       if(IndexDomain(ValueIndex)==-1 && ValueIndex>=0 && DomainHomomorphismIndex>=0 && DomainHomomorphismIndex<HomomorphismIndices())
                                       {
                                          if
                                          (
                                          ValueIndex<HomomorphismIndices()
                                          )
                                          {
                                             domain_homomorphism_index[DomainHomomorphismIndex]=ValueIndex;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=HomomorphismIndices() && HomomorphismIndices(HomomorphismIndices()+1))
                                          )
                                          {
                                             domain_homomorphism_index[HomomorphismIndices()-1]=ValueIndex;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
      
      int                           GetCodomainHomomorphismIndex(int CodomainHomomorphismIndex) { if(CodomainHomomorphismIndex>=0 && CodomainHomomorphismIndex<HomomorphismIndices()) { return(codomain_homomorphism_index[CodomainHomomorphismIndex]); } return(-1); }
      bool                          SetCodomainHomomorphismIndex(int CodomainHomomorphismIndex,int ValueIndex)
                                    {
                                       if(IndexDomain(ValueIndex)==-1 && ValueIndex>=0 && CodomainHomomorphismIndex>=0 && CodomainHomomorphismIndex<HomomorphismIndices())
                                       {
                                          if
                                          (
                                          ValueIndex<HomomorphismIndices()
                                          )
                                          {
                                             codomain_homomorphism_index[CodomainHomomorphismIndex]=ValueIndex;
                                             return(true);
                                          }
                                          else if
                                          (
                                          (ValueIndex>=HomomorphismIndices() && HomomorphismIndices(HomomorphismIndices()+1))
                                          )
                                          {
                                             codomain_homomorphism_index[HomomorphismIndices()-1]=ValueIndex;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
                                    
      int                           DomainIndices() { return(domain_indices); }
      bool                          DomainIndices(int Value) { if(Value>=0 && Value<INT_MAX) { domain_indices=Value; ArrayResize(domain_domain_index,domain_indices); ArrayResize(codomain_domain_index,domain_indices); return(true); } return(false); }
      
      int                           HomomorphismIndices() { return(homomorphism_indices); }
      bool                          HomomorphismIndices(int Value) { if(Value>=0 && Value<INT_MAX) { homomorphism_indices=Value; ArrayResize(domain_homomorphism_index,homomorphism_indices); ArrayResize(codomain_homomorphism_index,homomorphism_indices); return(true); } return(false); }
      
      bool                          FunctoringDomains(double DomainDomains,double CodomainDomains,double &Functorings[])
                                    {
                                       //return(F_D(DomainDomains,CodomainDomains,functoring_domains,Functorings));
                                       int _size=ArraySize(Functorings);
                                       ArrayFree(functoring_domains);ArrayResize(functoring_domains,_size);
                                       //
                                       for(int i=0;i<_size-1;i++)
                                       {
                                          functoring_domains[i]=Functorings[i];   
                                       }
                                       //
                                       if(_size==1 || DomainDomains==0.0)
                                       {
                                          functoring_domains[_size-1]=CodomainDomains-DomainDomains;
                                       
                                          return(true);
                                       }
                                       else if(ArraySize(Functorings)>1)
                                       {
                                          functoring_domains[_size-1]=CodomainDomains-Functorings[0];
                                          //
                                          for(int i=1;i<_size-1;i++)
                                          {
                                             functoring_domains[_size-1]-=(Functorings[i]*pow(DomainDomains,i));   
                                          }
                                          //
                                          functoring_domains[_size-1]/=(pow(DomainDomains,_size-1));
                                          
                                          printf(__FUNCSIG__+" last N coefficient"+DoubleToString(functoring_domains[_size-1]));
                                       
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
      bool                          FunctoringMorphisms(double &DomainMorphisms[],double &CodomainMorphisms[],double &Functorings[])
                                    {
                                       return(true);//F_M(DomainMorphisms,CodomainMorphisms,functoring_homomorphisms,Functorings));
                                    }
                                    
      /*int                           DomainHomomorphism(int HomomorphismIndex){ return(domain_homomorphism_index[HomomorphismIndex]); };
      bool                          DomainHomomorphism(int HomomorphismIndex,int DomainIndex) 
                                    { 
                                       if(DomainIndex>=0 && DomainIndex<domain_category.homomorphism[HomomorphismIndex].Morphisms()) 
                                       { 
                                          domain_homomorphism_index[HomomorphismIndex]=DomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(DomainIndex>domain_category.homomorphism[HomomorphismIndex].Morphisms() && DomainIndex<INT_MAX-1)
                                          { 
                                             domain_category.homomorphism[HomomorphismIndex].Morphisms(DomainIndex+1); domain_homomorphism_index[HomomorphismIndex]=DomainIndex; return(true); 
                                          } 
                                          else if(DomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(DomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(domain_category.homomorphism[HomomorphismIndex].Morphisms())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      int                           CodomainHomomorphism(int HomomorphismIndex){ return(codomain_homomorphism_index[HomomorphismIndex]); };
      bool                          CodomainHomomorphism(int HomomorphismIndex,int CodomainIndex) 
                                    { 
                                       if(CodomainIndex>=0 && CodomainIndex<codomain_category.homomorphism[HomomorphismIndex].Morphisms()) 
                                       { 
                                          codomain_homomorphism_index[HomomorphismIndex]=CodomainIndex; return(true); 
                                       }
                                       else
                                       {
                                          if(CodomainIndex>codomain_category.homomorphism[HomomorphismIndex].Morphisms() && CodomainIndex<INT_MAX-1)
                                          {
                                             codomain_category.homomorphism[HomomorphismIndex].Morphisms(CodomainIndex+1); codomain_homomorphism_index[HomomorphismIndex]=CodomainIndex; return(true); 
                                          } 
                                          else if(CodomainIndex!=-1)
                                          {
                                             printf(__FUNCSIG__+" index: "+IntegerToString(CodomainIndex)+" out of bounds for codomain cardinal: "+IntegerToString(codomain_category.homomorphism[HomomorphismIndex].Morphisms())+". "); 
                                          } 
                                       } 
                                       
                                       return(false); 
                                    }
      
      
      int                           DomainDomain(int DomainIndex){ return(domain_domain_index[DomainIndex]); };
      bool                          DomainDomain(int DomainIndex,int DomainDomainIndex) 
                                    { 
                                       if(DomainDomainIndex>=0 && DomainIndex<domain_category.domain[DomainIndex].Cardinality()) 
                                       { 
                                          domain_domain_index[DomainIndex]=DomainDomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(DomainDomainIndex>domain_category.domain[DomainIndex].Cardinality() && DomainIndex<INT_MAX-1)
                                          { 
                                             domain_category.domain[DomainIndex].Cardinality(DomainDomainIndex+1); domain_domain_index[DomainIndex]=DomainDomainIndex; return(true); 
                                          } 
                                          else if(DomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(DomainDomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(domain_category.domain[DomainIndex].Cardinality())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      
      int                           CodomainDomain(int CodomainIndex){ return(codomain_domain_index[CodomainIndex]); };
      bool                          CodomainDomain(int CodomainIndex,int CodomainDomainIndex) 
                                    { 
                                       if(CodomainDomainIndex>=0 && CodomainIndex<codomain_category.domain[CodomainIndex].Cardinality()) 
                                       { 
                                          codomain_domain_index[CodomainIndex]=CodomainDomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(CodomainDomainIndex>codomain_category.domain[CodomainIndex].Cardinality() && CodomainIndex<INT_MAX-1)
                                          { 
                                             codomain_category.domain[CodomainIndex].Cardinality(CodomainDomainIndex+1); codomain_domain_index[CodomainIndex]=CodomainDomainIndex; return(true); 
                                          } 
                                          else if(CodomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(CodomainDomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(codomain_category.domain[CodomainIndex].Cardinality())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }*/
      
      //
      
      /*bool                          FunctorDomain(CDomain<string> &D,CDomain<string> &C,int HomomorphismIndex,int DomainIndex,int CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<C.Cardinality())
                                       {
                                          domain_domain_index[HomomorphismIndex]=DomainIndex;
                                          codomain_domain_index[HomomorphismIndex]=CodomainIndex;
                                          
                                          domain_category.domain[HomomorphismIndex]=D;
                                          codomain_category.domain[HomomorphismIndex]=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
      bool                          FunctorHomomorphism(CHomomorphism<string,string> &D,CHomomorphism<string,string> &C,int HomomorphismIndex,int DomainIndex,int CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Morphisms() && CodomainIndex>=0 && CodomainIndex<C.Morphisms())
                                       {
                                          domain_homomorphism_index[HomomorphismIndex]=DomainIndex;
                                          codomain_homomorphism_index[HomomorphismIndex]=CodomainIndex;
                                          
                                          domain_category.homomorphism[HomomorphismIndex]=D;
                                          codomain_category.homomorphism[HomomorphismIndex]=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }*/
      
      void                          Let()
                                    {
                                       this.DomainIndices(0);
                                       this.HomomorphismIndices(0);
                                       this.codomain_category.Let();
                                       this.domain_category.Let();
                                    };
      
                                    CFunctor(void){};
                                    ~CFunctor(void){};
   };
//+------------------------------------------------------------------+
//| Enumeration for Monoid Operations                                |
//+------------------------------------------------------------------+
enum EOperations
  {
      OP_FURTHEST=5,
      OP_CLOSEST=4,
      OP_MOST=3,
      OP_LEAST=2,
      OP_MULTIPLY=1,
      OP_ADD=0
  };
//+------------------------------------------------------------------+
//| Monoid Class                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CMonoid                       : public CDomain<T>
   {
      protected:
      //double                        weights[];
      
      int                           identity;
      EOperations                   operation;
      
      public:
      
      double                        weights[];
      
      bool                          Weights(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX && Cardinality(Value)) 
                                       {  
                                          ArrayResize(weights,cardinal); 
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
      int                           Weights()
                                    { 
                                       return(Cardinality()); 
                                    }
      
      bool                          GetWeight(int WeightIndex,double &Weight) { if(WeightIndex>=0 && WeightIndex<Cardinality()) { Weight=weights[WeightIndex]; return(true); } return(false); }
                                    
      bool                          SetWeight(int ValueIndex,double Value) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          weights[ValueIndex]=Value;
                                          return(true);  
                                       }
                                       else
                                       { 
                                          printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Operation(EOperations Value) {  operation=Value; }
      EOperations                   Operation() { return(operation); }
      
      bool                          Identity(int ElementIdentity) { if(ElementIdentity>=0 && ElementIdentity<Cardinality()) { identity=ElementIdentity; return(true); } return(false); }
      int                           Identity() { return(identity); }
                                    
      int                           Operate(int IndexA,int IndexB)
                                    {
                                       int _operate=-1;
                                       
                                       if(IndexA>=0 && IndexA<Cardinality() && IndexB>=0 && IndexB<Cardinality())
                                       {
                                          if(this.Operation()==OP_ADD)
                                          {
                                             double _value=weights[IndexA]+weights[IndexB];
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(_value==weights[i]){ _operate=i; break; }
                                             }
                                          }
                                          else if(this.Operation()==OP_MULTIPLY)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(_value==weights[i]){ _operate=i; break; }
                                             }
                                          }
                                          else if(this.Operation()==OP_MOST)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             if(weights[IndexA]>=weights[IndexB])
                                             {
                                                _operate=IndexA;
                                             }
                                             else if(weights[IndexA]<=weights[IndexB])
                                             {
                                                _operate=IndexB;
                                             }
                                          }
                                          else if(this.Operation()==OP_LEAST)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             if(weights[IndexA]<=weights[IndexB])
                                             {
                                                _operate=IndexA;
                                             }
                                             else if(weights[IndexA]>=weights[IndexB])
                                             {
                                                _operate=IndexB;
                                             }
                                          }
                                          else if(this.Operation()==OP_FURTHEST)
                                          {
                                             double _value=0.5*(weights[IndexA]+weights[IndexB]);
                                             double _furthest=fabs(_value-weights[0]);
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(fabs(_value-weights[i])>_furthest){ _furthest=fabs(_value-weights[i]); _operate=i; }
                                             }
                                          }
                                          else if(this.Operation()==OP_CLOSEST)
                                          {
                                             double _value=0.5*(weights[IndexA]+weights[IndexB]);
                                             double _closest=fabs(_value-weights[0]);
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(fabs(_value-weights[i])<_closest){ _closest=fabs(_value-weights[i]); _operate=i; }
                                             }
                                          }
                                       }
                                       
                                       return(_operate);
                                    }
      
                                    CMonoid(){ identity=0; operation=OP_ADD; };
                                    ~CMonoid(){};
   };
//+------------------------------------------------------------------+
//| Monoid Action Class                                              |
//+------------------------------------------------------------------+
template <typename TM,typename TA>
class CMonoidAction                 : public CMonoid<TM>
   {
      protected:
      
      EOperations                   action;
      int                           modulo;
      
      public:
      
      CMonoid<TA>                   set;
      
      void                          Action(EOperations Value) {  action=Value; }
      EOperations                   Action() { return(action); }
      
      int                           GetModulo() {  return(modulo); }
                                    
      bool                          SetModulo(int Value) 
                                    { 
                                       if(Value>0 && Value%2==1 && Value<INT_MAX) 
                                       { 
                                          modulo=Value;
                                          return(/*set.Weights(modulo) && */set.Identity(int(round(modulo/2.0)-1.0)));
                                       }
                                       else
                                       { 
                                          printf(__FUNCSIG__+" value: "+IntegerToString(Value)+" is negative, even, or not an integer. "); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
      int                           OperateModulo(int Index,int Modulo=1)
                                    {
                                       int _operate=-1;
                                       
                                       if(Index>=0 && Index<this.Cardinality())
                                       {
                                          int _value=int(round(set.weights[Index]));
                                          
                                          _operate=_value%Modulo;
                                       }
                                       
                                       return(_operate);
                                    }
                                    
      bool                          IsInverseModulo(int IndexA,int IndexB)
                                    {
                                       if(IndexA!=IndexB && fabs(IndexA-set.weights[set.Identity()])==fabs(IndexB-set.weights[set.Identity()]))
                                       {
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
                                    
      int                           OperateGroup()
                                    {
                                       int _operate=-1;
                                       
                                       for(int i=0;i<GetModulo();i++)
                                       {
                                          for(int ii=0;ii<GetModulo();ii++)
                                          {
                                             if(i==ii)
                                               {
                                                
                                               }
                                          }
                                       }
                                       
                                       /*if(Modulo%2!=1){ return(_operate); }
                                       
                                       int _identity=int(round(Modulo/2.0)-1.0);
                                       
                                       if(_identity==IndexA){ _operate=IndexB; }
                                       else if(_identity==IndexB){ _operate=IndexA; }
                                       
                                       if(Index>=0 && Index<this.Cardinality())
                                       {
                                          _operate=int(round(weights[Index]))%Modulo;
                                       }*/
                                       
                                       return(_operate);
                                    }
      
                                    CMonoidAction(){ action=OP_CLOSEST; };
                                    ~CMonoidAction(){};
   };
//+------------------------------------------------------------------+
//| Monoid Group Class                                               |
//+------------------------------------------------------------------+
template <typename T>
class CMonoidGroup                 : public CMonoid<T>
   {
      protected:
      
      public:
      
      bool                          HasInversion() 
                                    {  
                                       bool _has_inversion=true;
                                       
                                       for(int i=0;i<this.Cardinality();i++)
                                       {
                                          bool _has_inverse=false;
                                          
                                          for(int ii=0;ii<this.Cardinality();ii++)
                                          {
                                             if(Operate(i,ii)==Identity()){ _has_inverse=true; }
                                          }
                                          
                                          if(!_has_inverse){ _has_inversion=false; break; }
                                       }
                                       
                                       return(_has_inversion); 
                                    }
      
                                    CMonoidGroup(){};
                                    ~CMonoidGroup(){};
   };
//+------------------------------------------------------------------+
//| Graph Class                                                      |
//+------------------------------------------------------------------+
template <typename T>
class CGraph                        //: public CDomain<T>
   {
      protected:
      
      int                           vertices;
      int                           arrows;
      
      public:
      
      CElement<T>                   vertex[];
      CElement<int>                 arrow[];
      
      bool                          Vertices(int Value) { if(Value>=0 && Value<INT_MAX) { vertices=Value; ArrayResize(vertex,vertices); return(true); } return(false); }
      int                           Vertices() { return(vertices); }
      
      bool                          Arrows(int Value) 
                                    { 
                                       if(Value>=0 && Value<INT_MAX) 
                                       { 
                                          arrows=Value; 
                                          ArrayResize(arrow,arrows); 
                                          
                                          for(int i=0;i<arrows;i++){ arrow[i].Cardinality(2); }
                                          
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
      int                           Arrows() { return(arrows); }
      
                                    
   };
//+------------------------------------------------------------------+
//| Fill Domain with handle data.                                    |
//+------------------------------------------------------------------+
template <typename T>
bool FillDomain(CDomain<T> &D,int Index,int Size,int &Handle,int Buffer=0)
   {
      double _buffer[];ArrayResize(_buffer,Size);ArrayInitialize(_buffer,0.0);
      
      if(CopyBuffer(Handle,Buffer,0,Size,_buffer)>=Size)
      {
         for(int p=0;p<Size;p++)
         {
            CElement<double> _e;
            if(_e.Cardinality(1))
            {
               if(_e.Set(0,_buffer[p]))
               { 
                  D.Set(p,_e); 
               }
            }
         }
      }
      
      return(true);
   }
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         TA _a;TB _b;
         if(A.Get(r,_a) && B.Get(r,_b) && _a!=_b)
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CDomain<TA> &A,CDomain<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         //printf(__FUNCSIG__+" type mismatch. ");
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         //printf(__FUNCSIG__+" cardinality mismatch. ");
         return(false);
      }
      
      /*if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }*/
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            //printf(__FUNCSIG__+" element mismatch at: "+IntegerToString(o));
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Morphism Match function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool MorphismMatch(CMorphism<TD,TC> &A,CMorphism<TD,TC> &B)
   {
      bool _matched=true;
      
      if(A.Domain()!=B.Domain()||A.Codomain()!=B.Codomain())
      {
         _matched=false;return(_matched);
      }
      
      if(!DomainMatch(A.domain,B.domain)||!DomainMatch(A.codomain,B.codomain))
      {
         _matched=false;return(_matched);
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Homomorphism Match function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool HomomorphismMatch(CHomomorphism<TD,TC> &A,CHomomorphism<TD,TC> &B)
   {
      if(A.Morphisms()!=B.Morphisms())
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int m=0; m<A.Morphisms(); m++)
      {
         CMorphism<TD,TC> _a;
         CMorphism<TD,TC> _b;
         
         if(A.Get(m,_a) && B.Get(m,_b) && !MorphismMatch(_a,_b))
         {
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            T _date;
            if(E.Get(r,_date)){ _element+=TimeToString(datetime(_date)); }
         }
         else if(string(typename(T))=="string")
         {
            T _string;
            if(E.Get(r,_string)){ _element+=string(_string); }
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            T _double;
            if(E.Get(r,_double)){ _element+=DoubleToString(double(_double)); }
         }
         else //if(string(typename(T))=="int")
         {
            T _int;
            if(E.Get(r,_int)){ _element+=IntegerToString(int(_int)); }
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CDomain<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
//| Print Morphism function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintMorphism(CMorphism<TD,TC> &M,int FloatPrecision=1)
   {
      string _morphism="";
      //
      CElement<TD> _d;
      CElement<TC> _c;
      ResetLastError();
      if(M.domain.Get(M.Domain(),_d) && M.codomain.Get(M.Codomain(),_c))
      {
         _morphism=PrintElement(_d,FloatPrecision);
         _morphism+="|----->";
         _morphism+=PrintElement(_c,FloatPrecision);
         _morphism+="\n";
      }
      else
      {
         //printf(__FUNCSIG__+" could not get element from: "+OBJECT_NAME(M.Domain)+", at domain index: "+IntegerToString(M.Domain())+" and/or "+OBJECT_NAME(M.Codomain)+", at codomain index: "+IntegerToString(M.Codomain())+", err: "+IntegerToString(GetLastError()));
      }
      //
      return(_morphism);
   }
//+------------------------------------------------------------------+
//| Print Homomorphism function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintHomomorphism(CHomomorphism<TD,TC> &H,int FloatPrecision=1)
   {
      string _homomorphism="\n\n"+PrintDomain(H.domain,FloatPrecision);
      //
      _homomorphism+="|\n";
      
      CMorphism<TD,TC> _m;
      for(int m=0;m<H.Morphisms();m++)
      {
         if(H.Get(m,_m))
         {
            _homomorphism+=(PrintMorphism(_m,FloatPrecision));
         }
      }
      //
      _homomorphism+="|\n";
      
      _homomorphism+=PrintDomain(H.codomain,FloatPrecision);
      //
      return(_homomorphism);
   }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool  M(matrix &Domain,vector &Codomain,vector &Inputs,double &Output,int Exponent=1) export
   {
      int _equations=int(Codomain.Size());
      
      if(_equations<=0||_equations>=INT_MAX||_equations!=Domain.Rows()-1||Domain.Cols()!=Domain.Rows()-1||_equations!=Inputs.Size())
      {
         printf(__FUNCSIG__+" invalid input rows or mismatched sizes...");
         return(false);
      }
      
      Output=0.0;
         
      if(Exponent==0 && _equations==1)
      {
         Output=Codomain[0];
         for(int c=0;c<int(Domain.Cols());c++)
         {
            Output-=Domain[0][c];
         }
         
         return(true);
      }
      else
      {
         //
         CMatrixDouble _a;_a.Resize(int(Domain.Cols()),int(Domain.Cols()));
         double _b[];ArrayResize(_b,int(Domain.Cols()));ArrayInitialize(_b,0.0);
         
         for(int v=0;v<int(Domain.Cols());v++)
         {
            _b[v]=(Codomain[v]-Inputs[v]);
            
            for(int vv=0;vv<int(Domain.Cols());vv++)
            {
               _a[v].Set(vv,Domain[v+1][vv]);
            }
         }
         
         int _info=0;
         CDenseSolver _S;
         CDenseSolverReport _r;
         double _x[];ArrayResize(_x,int(Domain.Cols()));ArrayInitialize(_x,0.0);
         
         _S.RMatrixSolve(_a,int(Domain.Cols()),_b,_info,_r,_x);
         
         for(int v=0;v<int(Domain.Cols());v++)
         {
            Output+=(_x[v]*pow(Domain[0][v],Exponent));
         }
      
         //printf(__FUNCSIG__+" coefficients array:... ");ArrayPrint(_C);
      
         return(true);
      }
      
      return(false);
   }
//+------------------------------------------------------------------+
