//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property version   "1.00"
#property script_show_inputs 
//+------------------------------------------------------------------+ 
input string user00 = "127.0.0.1";          //Address
input int    user01 = 27015;                //Port
//+------------------------------------------------------------------+
bool ConnectionWrite(int socket, string szMsg, bool TLS = false)
{
    char buff[];
    int  len = StringToCharArray(szMsg, buff) - 1;

    if (len < 0) return false;
    Print("To Server:", szMsg);
    return (TLS ? SocketTlsSend(socket, buff, len) : SocketSend(socket, buff, len)) == len;
}
//+------------------------------------------------------------------+
string ConnectionRead(int socket, uint timeout)
{
    uint len;
    int  ret;
    char resp[];
    string info;
    uint timeout_check = GetTickCount() + timeout;
    
    info = "";
    do
    {
            len = SocketIsReadable(socket);
            ret = SocketRead(socket, resp, len, timeout);
            if (ret > 0)
                    info += CharArrayToString(resp, 0, ret);
    }while ((GetTickCount() < timeout_check) && (!_StopFlag));
    
    return info;
}
//+------------------------------------------------------------------+
void OnStart()
{
    int socket = SocketCreate();
    
    if (socket == INVALID_HANDLE)
    {
            Print("Unable to create socket. Error: ", GetLastError());
            return;
    }
    if (!SocketConnect(socket, user00, user01, 1000))
    {
            Print("Connection with the address [", user00,"] in port: ",user01, " failed. Error code: ", GetLastError());
            SocketClose(socket);
            return;
    }
    
    Print("Trying to send ", ConnectionWrite(socket, "Testing Server Echo...") ? "Ok..." : "Failed...");
    
    Print("From Server:", ConnectionRead(socket, 1000));

    SocketClose(socket);
}
//+------------------------------------------------------------------+