//+------------------------------------------------------------------+
//|                                            Two SMA crossover.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

input uchar Risk=0;
input ushort SL=500,
             TP=350,
             PeriodMA1=34,
             PeriodMA2=16;

double lastMA1,lastMA2;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lastMA1=CalcMA(PeriodMA1);
   lastMA2=CalcMA(PeriodMA2);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      double curMA1=CalcMA(PeriodMA1),
             curMA2=CalcMA(PeriodMA2);

      if(curMA1>curMA2 && lastMA1<lastMA2)
         PutPosition(ORDER_TYPE_BUY);

      if(curMA1<curMA2 && lastMA1>lastMA2)
         PutPosition(ORDER_TYPE_SELL);

      lastMA1=curMA1;
      lastMA2=curMA2;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(ENUM_ORDER_TYPE type)
  {
//---
   double price=type==ORDER_TYPE_BUY? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID),
          lot=CalcLot(),margin;

   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;

   if(margin>AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money for ",EnumToString(type)," ",lot," ",_Symbol," Error code # ",GetLastError());
      return;
     }

   int slippage=(int)MathMax(SymbolInfoInteger(_Symbol,SYMBOL_SPREAD)/2,3),
       stoplvl=(int)SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL);
   double sl=0,tp=0;

   if(type==ORDER_TYPE_BUY)
     {
      sl=SymbolInfoDouble(_Symbol,SYMBOL_BID)-MathMax(stoplvl,SL)*_Point;
      tp=price+MathMax(stoplvl,TP)*_Point;
     }
   else
     {
      sl=SymbolInfoDouble(_Symbol,SYMBOL_ASK)+MathMax(stoplvl,SL)*_Point;
      tp=price-MathMax(stoplvl,TP)*_Point;
     }

   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.type=type;
   request.price=price;
   request.sl=NormalizeDouble(sl,_Digits);
   request.tp=NormalizeDouble(tp,_Digits);
   request.deviation=slippage;

   if(OrderSend(request,result)==false)
      Print("OrderSend error ",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcLot()
  {
//---
   int m=0,n=0,s=Risk+1,stoplvl=(int)SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL),
       sl=MathMax(stoplvl,SL),tp=MathMax(stoplvl,TP);

   HistorySelect(0,TimeCurrent());
   uint total=HistoryDealsTotal();

   for(uint i=0; i<total; i++)
     {
      ulong ticket=HistoryDealGetTicket(i);
      if(ticket>0 && HistoryDealGetInteger(ticket,DEAL_ENTRY)==DEAL_ENTRY_OUT)
        {
         n++;
         if(HistoryDealGetDouble(ticket,DEAL_PROFIT)>0)
            m++;
        }
     }

   double pv=SymbolInfoDouble(_Symbol,SYMBOL_TRADE_TICK_VALUE)*SymbolInfoDouble(_Symbol,SYMBOL_POINT)/SymbolInfoDouble(_Symbol,SYMBOL_TRADE_TICK_SIZE),
          p=(m+0.5*s)/(n+s),lot=AccountInfoDouble(ACCOUNT_MARGIN_FREE)*(p*tp-(1-p)*sl)/(pv*sl*tp),
          lot_min=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN),lot_step=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP);

   lot=MathMax(0,MathRound((lot-lot_min)/lot_step))*lot_step+lot_min;
   return(MathMin(lot,SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MAX)));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcMA(int period)
  {
//---
   double sum=0;
   for(int i=0; i<period; i++)
      sum=sum+iOpen(_Symbol,PERIOD_CURRENT,i);
   return(sum/period);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
