//==================================================================================================
//                                                                            Linear_Sinus_FT.mq4 //
//                                                                             buldakov_a@mail.ru //
//                                                                                        USD/JPY //
//                                                                                     16.10.2009 //
//==================================================================================================
#property indicator_chart_window                                                                  //
#property indicator_buffers 2                                                                     //
#property indicator_color1 Blue                                                                   //
#property indicator_color2 Red                                                                    //
//===   ===========================================================================
extern int Hours=600;                                                                             //
//===   ========================================================================
int limit;                                                                                        //
int j,i,n,t;                                                                                      //
double pi=3.14159265,Num,Den;                                                                     //
double syi,syti,stti,stttti,sOuti,si,sOutti,sOuttti,a,b,c;                                        //
double Alfa,dAlfa;                                                                                //
//===    ========================================================================
double Sinus[],Out[];                                                                             //
//===   ========================================================================
int init()                                                                                        //
{                                                                                                 //
//===        ==============================
SetIndexShift(0,0);                                                                               //
SetIndexShift(1,0);                                                                               //
//===        ===========================================
SetIndexDrawBegin(0,0);                                                                           //
SetIndexDrawBegin(1,0);                                                                           //
//=== 2    ========================================================
SetIndexBuffer(0,Sinus);                                                                          //
SetIndexBuffer(1,Out);                                                                            //
//===       =============================================
SetIndexStyle(0,DRAW_NONE,EMPTY,1);                                                               //
SetIndexStyle(1,DRAW_LINE,EMPTY,2);                                                               //
//===     =============================================================
SetIndexLabel(0,NULL);                                                                            //
SetIndexLabel(1,NULL);                                                                            //
//==================================================================================================
return(0);                                                                                        //
}                                                                                                 //
//===   ======================================================================
int deinit()                                                                                      //
{ return(0); }                                                                                    //
//===          ========================
int start()                                                                                       //
{                                                                                                 //
//==================================================================================================
int counted_bars=IndicatorCounted();                                                              //
if(counted_bars<0) return(-1);                                                                    //
//===                                                       //
if(counted_bars>0) counted_bars--;                                                                //
limit=Bars-counted_bars;                                                                          //
//===  =======================================================================================
if (Hours<=2) Hours=2;                                                                            //
n=((Hours*60)/Period())/2;                                                                        //
//===    =================================================================
    for(j=(2*n); j>=0; j--)                                                                       //
    {                                                                                             //
       Num=0;Den=0;                                                                               //
       for(i=(n+n); i>=0; i--)                                                                    //
       {                                                                                          //
         Num=Num+MathSin(i*pi/(n+n))*Close[j+i];                                                  //
         Den=Den+MathSin(i*pi/(n+n));                                                             //
       }                                                                                          //
     Sinus[j+n]=Num/Den;                                                                          //
       for(i=n; i>=0; i--)                                                                        //
       {                                                                                          //
     Sinus[i]=Sinus[n+0]+(Sinus[n+0]-Sinus[n+1])*(n-i);                                           //
       }                                                                                          //
    }                                                                                             //
//===     ========================================================
t=2*n+1;                                                                                          //
stti=(t*t*t-t)/12;                                                                                //
stttti=(3*t*t*t*t*t-10*t*t*t+7*t)/240;                                                            //
sOuti=0.0;si=0.0;sOutti=0.0;sOuttti=0.0;                                                          //
  for(i=(n*2); i>=0; i--)                                                                         //
  {                                                                                               //
  sOuti=sOuti+Sinus[i];                                                                           //
  si=si+(-i+(t/2));                                                                               //
  sOutti=sOutti+(Sinus[i]*(-i+(t/2)));                                                            //
  sOuttti=sOuttti+(Sinus[i]*(-i+(t/2))*(-i+(t/2)));                                               //
  }                                                                                               //
b=sOutti/stti;                                                                                    //
c=-((sOuti/t)-(sOuttti/stti))/MathAbs((stti/t)-(stttti/stti));                                    //
a=(sOuti-stti*c)/t;                                                                               //
  for(i=(2*n); i>=0; i--)                                                                         //
  {                                                                                               //
  Out[i]=a+b*(-i+(t/2))+c*(-i+(t/2))*(-i+(t/2));                                                  //
  }                                                                                               //
//==================================================================================================
dAlfa=0;                                                                                          //
Alfa=((Out[0]-Out[60/Period()]))/Point;                                                           //
if (Alfa>0) dAlfa=(((Out[0]-Out[60/Period()])-(Out[60/Period()]-Out[120/Period()])))/Point;       //
if (Alfa<0) dAlfa=(((Out[120/Period()]-Out[60/Period()])-(Out[60/Period()]-Out[0])))/Point;       //
//==================================================================================================
Comment(                                                                                          //
"   ",TimeToStr(CurTime()),"\n",                                                        //
         "       ",DoubleToStr(Hours,0)," ","\n",                                        //
        "  ",DoubleToStr(Alfa,1)," /",                                            //
        "     ",DoubleToStr(dAlfa,3)," /^2");                            //
return(0);                                                                                        //
}                                                                                                 //
//==================================================================================================

