//+------------------------------------------------------------------+
//|                                             eTestColorDialog.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_ColorInput.mqh>
//+------------------------------------------------------------------+
//| eColorScheme                                                     |
//+------------------------------------------------------------------+
enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=AquaBlackScheme;

CColorInput ci;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);
   ci.Init("CI",15,"Color selection",clrBlue);
   ci.SetSubWindow("TestSubWindow");
   ci.SetColor(clrYellow);
   ci.Show(25,25);
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   ci.Hide();
  }

//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {

   if(ci.Event(id,lparam,dparam,sparam)==1)
     {
      Alert("The color you choose is: "+ColorToString(ci.Color(),true));
     }

   if(CHARTEVENT_CHART_CHANGE)
     {
      ci.SetSubWindow("TestSubWindow");
     }
  }
//+------------------------------------------------------------------+
