// 22.01.2009   
//+X================================================================X+
//|                                    Moving Average 2p-IdealMA.mq4 |
//|                                      Copyright  2009,   Neutron |                                                                   | 
//+X================================================================X+
//----     
#property indicator_chart_window
//----   
#property  indicator_buffers 1
//----   
#property indicator_color1 Blue
//----   
extern double w1 =0.1;
extern double w2 = 0.1;
//----  
double MA[];
//---- 
int StartBar;
//+X================================================================X+
//|  2p-IdealMA function                                             |
//+X================================================================X+
double GetIdealMASmooth(double W1_, double W2_,
                       double Series1, double Series0, double Resalt1)
 {
//---+
   double Resalt0, dSeries, dSeries2;
   dSeries = Series0 - Series1;
   dSeries2 = dSeries * dSeries -1.0;
   
   Resalt0 = (W1_ * (Series0 - Resalt1) + 
                   Resalt1 + W2_ * Resalt1 * dSeries2) 
                                           / (1.0 + W2_ * dSeries2);	
   return(Resalt0);
//---+ 
 }
//+X================================================================X+
//|  initialization function                                         |
//+X================================================================X+
int init()
 {
//---+
   //----   
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 3);
   //----     
   SetIndexBuffer(0, MA);
   //----     
   StartBar = 2;
   //----
   return(0);
//---+
 }
//+X================================================================X+
//|  start function                                                  |
//+X================================================================X+
int start()
 {
//---+
   //----    
                           //    
   if (Bars - 1 < StartBar)
                       return(-1);
   //----         
   int MaxBar, limit, bar, counted_bars = IndicatorCounted();  
   //----    
   if (counted_bars < 0)
                  return(-1);
   //----      
   if (counted_bars > 0)
              counted_bars--;
   //----     ,
            //       
   MaxBar = Bars - 2;       
   //----     ,
            //       
   limit = Bars - counted_bars - 1; 
   //----     
   if (limit >= MaxBar)
     {
      limit = MaxBar;
      MA[MaxBar] = Close[MaxBar];
	   MA[MaxBar + 1] = Close[MaxBar + 1];
     } 
   //----    
	for( bar = limit; bar >= 0; bar--)
      MA[bar] = GetIdealMASmooth(w1, w2, 
                            Close[bar + 1], Close[bar], MA[bar + 1]);
   //----
   return(0);
//---+
 }
//+X----------------------------------------------------------------X+

