//+------------------------------------------------------------------+
//|                                       Fractal_Level_Xrust_V2.mq4 |
//|                                 Copyright  2008, XrustSolution. |
//|                                            http://xrust.ucoz.net |
//+------------------------------------------------------------------+
#property copyright "#Copyright  2008, XrustSolution.#"
#property link      "#xrust.ucoz.net#"

#property indicator_chart_window
extern int    TimeFrame=0;//=0,  
extern int    DistanseAp=0;//     
extern int    DistanseDn=0;//     
extern int    MagicNumb =0;//
extern string FrApNam="Ap";//  . 
extern string FrDnNam="Dn";//  . 
extern color  ClAp=Blue;//  . 
extern color  ClDn=Red;//  . 
extern bool   comment=true;//  
extern bool   Orders=true;//
//-----------------------------------------------------------------------------+
double FrPrise;
double FrApPrise=0,FrDnPrise=0;
bool _magic;
//+----------------------------------------------------------------------------+
void init(){
  if(MagicNumb==0){_magic=false;}else{_magic=true;}
  if(TimeFrame==0){TimeFrame=Period();}
  IndicatorShortName("Factal_Level_Xrust"+TimeFrame);
  FrApNam=StringConcatenate(FrApNam,TimeFrame);
  FrDnNam=StringConcatenate(FrDnNam,TimeFrame);
  return;}
void deinit(){
  ObjectDelete(FrDnNam);
  ObjectDelete(FrApNam);
  Comment(" ");
  return;}
//+----------------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int limit;
   double tmp;
   int i, j,k;
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//-----------------------------------------------------------------------------+
  if(Orders){
   if(OrdersTotal()>0){
    for(i=0;i<OrdersTotal();i++){
     if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
      if(OrderSymbol()==Symbol()&&OrderType()<2){
       if(_magic){
        if(OrderMagicNumber()==MagicNumb){
        ObjectDelete(FrDnNam);
        ObjectDelete(FrApNam);
        return(0);}}
       ObjectDelete(FrDnNam);
       ObjectDelete(FrApNam);        
       return(0);}}}}}
   LineAp();
   LineDn();
   string FAP=DoubleToStr((FrApPrise-DistanseAp*Point),Digits);
   string FDP=DoubleToStr((FrDnPrise+DistanseDn*Point),Digits);
   int diap=MathRound((FrApPrise-FrDnPrise)/Point);
   if(comment){Comment("TimeFrame="+TimeFrame+
                       "\nApPrise ="+FAP+
                       "\nDnPrise ="+FDP+
                       "\nFractal Channel ="
                       +diap+"Point");}

   return(0);
  }
//-----------------------------------------------------------------------------+
//               |   
//-----------------------------------------------------------------------------+
   void LineDn(){
   FrPrise=NormalizeDouble(FindNearFractal(0,TimeFrame,MODE_LOWER),MarketInfo(Symbol(),MODE_DIGITS));
   FrPrise=NormalizeDouble(FrPrise-DistanseDn*Point,MarketInfo(Symbol(),MODE_DIGITS));
   //Comment(FrPrise);
   if(ObjectFind(FrDnNam)==0){
     if(ObjectGet(FrDnNam,OBJPROP_PRICE1)==FrPrise){return;}}
   FrDnPrise=FrPrise;  
   ObjectDelete(FrDnNam);
   SetHLine(ClDn,FrDnNam,FrDnPrise,0,1);
   WindowRedraw();
   return;} 
//-----------------------------------------------------------------------------+
//               | 
//-----------------------------------------------------------------------------+
   void LineAp(){
   FrPrise=NormalizeDouble(FindNearFractal(0,TimeFrame,MODE_UPPER),MarketInfo(Symbol(),MODE_DIGITS));
   FrPrise=NormalizeDouble(FrPrise+DistanseAp*Point,MarketInfo(Symbol(),MODE_DIGITS));
   if(ObjectFind(FrApNam)==0){
     if(ObjectGet(FrApNam,OBJPROP_PRICE1)==FrPrise){return;}}
   FrApPrise=FrPrise; 
   ObjectDelete(FrApNam); 
   SetHLine(ClAp,FrApNam,FrApPrise,0,1);
   WindowRedraw();
   return;}
//-----------------------------------------------------------------------------+   
//       !!!                                                |       
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 07.10.2006                                                     |
//|   :   .   .         |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy   -        (""  NULL -  )     |
//|    tf   -                      (    0       -  )         |
//|    mode -                    (MODE_LOWER|MODE_UPPER)            |
//+----------------------------------------------------------------------------+
double FindNearFractal(string sy="0", int tf=0, int mode=MODE_LOWER) {
  if (sy=="" || sy=="0") sy=Symbol();
  double f=0;
  int    d=MarketInfo(sy, MODE_DIGITS), s;
  if (d==0) if (StringFind(sy, "JPY")<0) d=4; else d=2;

  for (s=2; s<100; s++) {
    f=iFractals(sy, tf, mode, s);
    if (f!=0) return(NormalizeDouble(f, d));
  }
  Print("FindNearFractal():   ");
  return(0);
}
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 30.03.2008                                                     |
//|   :   OBJ_HLINE                 |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    cl -                                                           |
//|    nm -                ("" -    )     |
//|    p1 -              (0  - Bid)                              |
//|    st -                  (0  -  )                    |
//|    wd -                 (0  -  )                     |
//+----------------------------------------------------------------------------+
void SetHLine(color cl, string nm="", double p1=0, int st=0, int wd=1) {
  if (nm=="") nm=DoubleToStr(Time[0], 0);
  if (p1<=0) p1=Bid;
  if (ObjectFind(nm)<0) ObjectCreate(nm, OBJ_HLINE, 0, 0,0);
  ObjectSet(nm, OBJPROP_PRICE1, p1);
  ObjectSet(nm, OBJPROP_COLOR , cl);
  ObjectSet(nm, OBJPROP_STYLE , st);
  ObjectSet(nm, OBJPROP_WIDTH , wd);
}