//+------------------------------------------------------------------+
//|                                     history_data_analysis_v3.mq4 |
//|                              Copyright  2007, Kiriyenko Dmitriy |
//|                                      http://kiriyenko.moikrug.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Kiriyenko Dmitriy"
#property link      "http://kiriyenko.moikrug.ru"
//----
#property show_inputs
#define FILE_NAME "history_data_analysis_v3.ex4"
#define WRONG_TF "     M1-H4.\n\n  ."
#define WRONG_TF_HDR "    !"
#define WRONG_BREAKUP " break_up        .\n"
#define BREAKUP_CHANGE " breakup_min    "
#define WRONG_BREAKUP_HDR "   !"
#define WRONG_FILE_EXT "  :    *.hst "
#define WRONG_FILE_EXT_HDR "  "
//----
extern string header0 = "<----------   ---------->";
extern bool   input_from_file = false;
extern string input_file_name = ".hst";
extern bool   input_file_in_history = true;
//----
extern string header1 = "<----------   ---------->";
extern bool   bars_ignore = true; //  
extern int    hole_min    = 3; //   ,    
//----
extern int breakup_min    = 20; // -  ,    

extern bool gap_ignore    = true; // 
extern int  gap_min       = 5; // -  ,    
//----
extern string header2 = "<----------   ---------->";
extern bool report_summary = false; //  
extern bool report_table = true; //  
//----
string begin_week_sessions = "00:00"; //     (:)
string end_week_sessions = "21:59";   //     (:)
bool   new_file = true;               // ,      
int    in_handle, out_handle;         //    
int    err;                           //     
//----
#include <WinUser32.mqh>
#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int      period;               //   
   string   symbol;               //  
   int      bars;                 //    
   double   point;                //     
   datetime time_start, time_end; //    
//        
   if(input_from_file)
     {
       //  
       if(file_ext(input_file_name) != "hst")
         {
           MessageBox(WRONG_FILE_EXT, WRONG_FILE_EXT_HDR, MB_OK | MB_ICONSTOP);
           return(-3);
         }
       //  
       if(input_file_in_history)
           in_handle = FileOpenHistory(input_file_name, FILE_BIN | FILE_READ);
       else
           in_handle = FileOpen(input_file_name, FILE_BIN | FILE_READ);
       err = GetLastError();
       if(in_handle < 0 || err > 0) 
           return(error_out(err, "  "));
       //   
       bars = (FileSize(in_handle) - 148) / 44;
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "   "));
       //    
       FileSeek(in_handle, 68, SEEK_SET);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "     "));
       //  /
       symbol = FileReadString(in_handle, 12);
       period = FileReadInteger(in_handle, LONG_VALUE);
       int digits = FileReadInteger(in_handle, LONG_VALUE);
       point = MathPow(10, -digits);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "      "));
       //     
       FileSeek(in_handle, 60, SEEK_CUR);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "      "));
       time_start = FileReadInteger(in_handle, LONG_VALUE);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "     "));
       FileSeek(in_handle, -44, SEEK_END);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "      "));
       time_end = FileReadInteger(in_handle, LONG_VALUE);
       err = GetLastError();
       if(err > 0) 
           return (error_out(err, "     "));
       //       *.hst 
       FileSeek(in_handle, 148, SEEK_SET);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "      "));
     }
   else //      
     {
       bars = Bars;
       symbol = Symbol();
       period = Period();
       point = Point;
       time_start = Time[Bars-1];
       time_end = Time[0];
     }
//    
   string time_frame;    // 
   int duration_bar = period*60;  //    .
   switch(period)
     {
       case 1:   time_frame = "M1";  break;
       case 5:   time_frame = "M5";  break;
       case 15:  time_frame = "M15"; break;
       case 30:  time_frame = "M30"; break;
       case 60:  time_frame = "H1";  break;
       case 240: time_frame = "H4";  break;
       default: 
           MessageBox(WRONG_TF, WRONG_TF_HDR, MB_OK | MB_ICONWARNING | MB_DEFBUTTON1); 
           return(-2);
     }
//      
   if(hole_min < 1) 
       hole_min = 1; 
   if(bars_ignore == false) 
       hole_min = 1;
//      
   if(gap_min < 0) 
       gap_min = 0;
   if(gap_ignore == false) 
       gap_min = 0;
   if(breakup_min < hole_min)
     { 
       string message = StringConcatenate(WRONG_BREAKUP, BREAKUP_CHANGE, hole_min);
       int warning_1 = MessageBox(message, WRONG_BREAKUP_HDR,
                                  MB_OKCANCEL | MB_ICONWARNING | MB_DEFBUTTON1); 
       if(warning_1 == 1) 
           breakup_min = hole_min;  
       else 
           return(-1);
       err = GetLastError();
       if(err > 0) 
           return(error_out(err, "     "));
     }
//   
   string date_start = TimeToStr(time_start, TIME_DATE);
   string date_end   = TimeToStr(time_end, TIME_DATE);
   string file_name = StringConcatenate(symbol, "_", time_frame, "_holes_",
                                        date_start, "-", date_end, ".csv");
//   
   out_handle = FileOpen(file_name, FILE_CSV |FILE_WRITE, ";");
   err = GetLastError();
   if(out_handle < 0 || err > 0) 
       return(error_out(err, "  "));
//    
   int    week_seconds = 604800; //    
   double weeks;                 //        
//    .
   datetime holiday = StrToTime(begin_week_sessions) - StrToTime(end_week_sessions)
                        + (24*3600*3) - duration_bar;
   int hole_range; //  
   int bars_hole;  //   
   int holes_total_amount;   //   
   int breakup_total_amount; //   
   int bars_hole_amount;     //     
   int bars_breakup_amount;  //     
   int gap_total_amount;     //   
   int gap_holes;            //    
   int gap_breakups;         //    
   int hole_max;             //   
   int breakup_max;          //   
   int gap_max;              //   
   bool note_ = false;
   double months, days, hours, minutes, seconds;
   int n = 1;
   for(int h = 0; h < bars; h++)
     {
       //       
       datetime bar_time_current, bar_time_previous;
       //          
       double open_price_current, close_price_previous;
       if(!input_from_file)
         {
           bar_time_current  = iTime(NULL, 0, Bars - h - 2);
           bar_time_previous = iTime(NULL, 0, Bars - h - 1);
           open_price_current   = NormalizeDouble(Open[Bars - h - 2],4);
           close_price_previous = NormalizeDouble(Close[Bars - h - 1],4);
         }
       else
         {
           bar_time_previous = FileReadInteger(in_handle, LONG_VALUE);
           err = GetLastError();
           //   ,  
           if(err == 4099) 
               break; 
           if(err > 0) 
               return(error_out(err, "     ."));
           FileSeek(in_handle, 24, SEEK_CUR);
           err = GetLastError();
           if(err > 0) 
               return(error_out(err, "  .   .. . "));
           close_price_previous = FileReadDouble(in_handle, DOUBLE_VALUE);
           if(err == 4099) 
               break; //   ,  
           err = GetLastError();
           if(err > 0) 
               return(error_out(err, "     "));
           FileSeek(in_handle, 8, SEEK_CUR);
           err = GetLastError();
           if(err > 0) 
               return(error_out(err, "     ."));
           bar_time_current = FileReadInteger(in_handle, LONG_VALUE);
           open_price_current = FileReadDouble(in_handle, DOUBLE_VALUE);
           err = GetLastError();
           if(err == 4099) 
               break; //   ,  
           if(err > 0) 
               return(error_out(err, "  .  ."));
           FileSeek(in_handle, -12, SEEK_CUR);
           err = GetLastError();
           if(err > 0) 
               return(error_out(err, "      "));
         }
       //   
       double abs_gap  = MathAbs(open_price_current - close_price_previous);
       double pips_gap = NormalizeDouble(abs_gap/point, 0);  
       //      
       int time_frame_range = bar_time_current - bar_time_previous; 
       if(time_frame_range > duration_bar) // -     
         {
           // -        
           if(time_frame_range > week_seconds) 
             {
               //     
               weeks = MathFloor(time_frame_range / week_seconds); 
                  
               if(TimeDayOfWeek(bar_time_previous) > TimeDayOfWeek(bar_time_current))
                   hole_range = time_frame_range - holiday * (1 + weeks) - duration_bar;
               else 
                   hole_range = time_frame_range - (holiday * weeks) - duration_bar;
             } 
           else
             {
               weeks = 0;
               if(TimeDayOfWeek(bar_time_previous) > TimeDayOfWeek(bar_time_current))
                   hole_range = time_frame_range - holiday - duration_bar;
               else 
                   hole_range = time_frame_range - duration_bar;
             }
           bars_hole = hole_range / duration_bar;
           if(bars_hole >= hole_min && pips_gap >= gap_min)
             { 
               holes_total_amount++;          //    ()
               //      ()
               bars_hole_amount += bars_hole;
               int gap;
               if(pips_gap >= gap_min) 
                 {
                   gap_holes += pips_gap; //     
                   gap = pips_gap;
                   if(pips_gap == 0) 
                       n = 0; 
                 }
               else 
                   gap = 0;
               seconds = bars_hole * duration_bar;
               string duration_hole = interval_to_str(seconds);
               if(bars_hole >= breakup_min)
                 {
                   //   
                   breakup_total_amount++;
                   //     
                   bars_breakup_amount += bars_hole; 
                   //    
                   gap_breakups += pips_gap; 
                 }
               if(hole_max < bars_hole && bars_hole < breakup_min)
                 {
                   //  
                   hole_max = bars_hole;
                   // / 
                   int number_hole = holes_total_amount;
                 } 
               if(breakup_max <= bars_hole && bars_hole >= breakup_min)
                 {
                   //  
                   breakup_max = bars_hole;
                   // / 
                   int number_breakup = holes_total_amount;
                 }     
               if(gap_max <= pips_gap)
                 {
                   //  
                   gap_max = pips_gap;
                   // / 
                   int number_gap = holes_total_amount; 
                 }     
               //   *.csv 
               if(new_file && report_table)
                 {
                   if(report_summary)
                     {
                       FileSeek (out_handle, 2400, SEEK_END);
                       err = GetLastError();
                       if(err > 0) 
                           return(error_out(err, "    "));
                     }
                   FileWrite(out_handle, " /"," ", " ",
                                         " ()", " ()",
                                         "", " ()");
                   err = GetLastError();
                   if(err > 0) 
                       return(error_out(err, "  "));
                   new_file = false;
                 }
               FileWrite(out_handle, holes_total_amount,
                         TimeToStr(bar_time_previous + duration_bar),
                         TimeToStr(bar_time_current),
                         bars_hole, bars_hole*Period(),
                         duration_hole, gap);
               err = GetLastError();
               if(err > 0) 
                   return(error_out(err, "  "));
               //    
               int hole_range_max = number_hole;
               int breakup_range_max = number_breakup;
               int gap_range_max = number_gap;
             }
         }
     }
   //   "   "
   err = GetLastError();
   if(err > 0 && err != 4002) 
       return(error_out(err, "   "));
   //   *.csv  
   double bars_hole_amount_     = bars_hole_amount;     
   double bars_breakup_amount_  = bars_breakup_amount;  
   double holes_total_amount_   = holes_total_amount;   
   double breakup_total_amount_ = breakup_total_amount; 
   double gap_holes_            = gap_holes;
   double gap_total_amount_     = gap_total_amount;
   double bars_                 = bars;
   double hole_average_size_; 
   if(holes_total_amount != breakup_total_amount)
     {
       seconds = (bars_hole_amount - bars_breakup_amount) * duration_bar;
       string duration_holes = interval_to_str(seconds);
       hole_average_size_ = NormalizeDouble((bars_hole_amount_ - 
                                            bars_breakup_amount_) /
                                            (holes_total_amount_ - 
                                            breakup_total_amount_), 2);
       int only_holes_total_amount_ = (holes_total_amount - breakup_total_amount);
       int bars_only_hole_amount_ = (bars_hole_amount - bars_breakup_amount);
     }
   seconds = time_end - time_start;
   string duration_period = interval_to_str(seconds);
   if (holes_total_amount > 0)
     {
       seconds = bars_hole_amount * duration_bar;
       string duration_holes_ = interval_to_str(seconds);        
       double hole_average_size = NormalizeDouble(bars_hole_amount_/holes_total_amount_,2);
       string gap_average_size  = NormalizeDouble(gap_holes_/holes_total_amount_, 2);

       FileSeek(out_handle, 0, SEEK_SET);
       err = GetLastError();
       if (err > 0) return (error_out(err,"      "));
       
       string hole_comment;
       if (hole_min == breakup_min) hole_comment = " <>,  "+
                                                   "  )";
       else hole_comment = StringConcatenate(hole_min," - ",breakup_min,"  )"); 
       hole_comment = StringConcatenate("  ( ",hole_comment);

       string breakup_comment = StringConcatenate(" ( ",breakup_min,"   )");
       
       if (breakup_total_amount != 0)          
       {
           seconds = bars_breakup_amount * duration_bar;
           string duration_breakups = interval_to_str(seconds);
           double breakup_average_size = NormalizeDouble(bars_breakup_amount_
                                                           /breakup_total_amount_, 2);
       }

       if (report_summary)
       {
           FileWrite(out_handle, "\n      ");
           FileWrite(out_handle, " - ",Symbol(),"",time_frame);
           FileWrite(out_handle, "",date_start,date_end);
           FileWrite(out_handle, "  ",bars,"");
           FileWrite(out_handle, " ()",(time_end-time_start)/60,
                                 duration_period);
           FileWrite(out_handle, "\n    ");
           FileWrite(out_handle, "",holes_total_amount);
           FileWrite(out_handle, " ",bars_hole_amount,"");
           FileWrite(out_handle, " ()",
                                 (bars_hole_amount*duration_bar)/60,duration_holes_);
           FileWrite(out_handle, " ",hole_average_size,"");
           FileWrite(out_handle, " ",gap_holes,"");
           FileWrite(out_handle," ",gap_max,"","",gap_range_max);
           FileWrite(out_handle, " ",gap_average_size,"");
           FileWrite(out_handle, "\n" + hole_comment);
           FileWrite(out_handle,  "",only_holes_total_amount_);
           FileWrite(out_handle, "",bars_only_hole_amount_,"");
           FileWrite(out_handle, " ()",
                                 (bars_hole_amount-bars_breakup_amount)*duration_bar/60,
                                 duration_holes);
           FileWrite(out_handle, " ",hole_max,"",hole_range_max);
           FileWrite(out_handle, " ",hole_average_size_);
           FileWrite(out_handle, "\n" + breakup_comment);
           FileWrite(out_handle, "",breakup_total_amount);
           FileWrite(out_handle, "",bars_breakup_amount,"");
           FileWrite(out_handle, " ()",bars_breakup_amount*duration_bar/60,
                                 duration_breakups);
           FileWrite(out_handle, " ",breakup_max,"","",
                                 breakup_range_max);
           FileWrite(out_handle, " ",breakup_average_size,"\n");
           err = GetLastError();
           if (err > 0) return (error_out(err," "));
       }
     }
   else
     {
       FileWrite(out_handle, "       ");
       err = GetLastError();
       if (err > 0) return (error_out(err," \"  \""));
     }
   FileClose(out_handle);
   err = GetLastError();
   if(err > 0) 
       return(error_out(err, " "));
   MessageBox("   MT4: \Experts\files\   :\n\n" + file_name, 
              "    ", MB_OK | MB_DEFBUTTON1);
   err = GetLastError();
   if(err > 0) 
       return(error_out(err, "    "));
   return(0);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string interval_to_str(int seconds)
  {
   int hours = seconds / 3600;
   int minutes = seconds % 3600 / 60;
   string str_interval;
   string zero_h = "", zero_m = ""; 
   if(hours < 10) 
       zero_h = "0"; 
   if(minutes < 10) 
       zero_m = "0"; 
   str_interval = StringConcatenate(zero_h, DoubleToStr(hours, 0), ":",
                                    zero_m, DoubleToStr(minutes, 0));            
   if(hours > 24)  
     {
       int days = hours / 24; hours = hours % 24;
       if(hours < 10) 
           zero_h = "0";
       str_interval = StringConcatenate(DoubleToStr(days, 0), " . ",
                                        zero_h, DoubleToStr(hours, 0), ":",
                                        zero_m, DoubleToStr(minutes, 0));  
       if(days > 30)   
         {
           int months = days/30; days = days%30;
           str_interval = StringConcatenate(DoubleToStr(months,0)," . ",
                                            DoubleToStr(days,0)," . ",
                                            zero_h,DoubleToStr(hours,0),":",
                                            zero_m,DoubleToStr(minutes,0));  
           
           if(months > 12) 
             {
               int years  = months / 2; months = months % 12;
               str_interval = StringConcatenate(DoubleToStr(years, 0), "  ",
                                                   DoubleToStr(months, 0), " . ",
                                                   DoubleToStr(days, 0), "   ",
                                                   zero_h, DoubleToStr(hours, 0),":",
                                                   zero_m, DoubleToStr(minutes, 0));
             }
         }
     }   
   return (str_interval);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int error_out(int err, string where)
  {
   if (err == 0) return;
   string message = StringConcatenate(" ", err, ":\"", ErrorDescription(err), "\"\n",
                                      "    \"", where, "\"");
   string caption = StringConcatenate("   : \"", FILE_NAME, "\"!");
   MessageBox(message, caption, MB_OK | MB_ICONSTOP);
   return (err);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string file_ext(string file_name)
  {
   string result = StringSubstr(file_name, StringLen(file_name) - 3, 3);
   int err = GetLastError();
   if(err > 0) 
       return(error_out(err, "  - "));
   return (result);
  }
//+------------------------------------------------------------------+

