//+------------------------------------------------------------------+
//|                                         i-SpectrAnalysis_RSI.mq5 |
//|                                           Copyright  2006, klot |
//|                                                     klot@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, klot"
#property link      "klot@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       Blue 
#property indicator_color1 clrBlue
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "i-SpectrAnalysis_RSI"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 70.0
#property indicator_level2 50.0
#property indicator_level3 30.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                //        
//+----------------------------------------------+
//|   dt_FFT.mqh               |
//+----------------------------------------------+
#include <dt_FFT.mqh> 
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint                 RSIPeriod=14;
input ENUM_APPLIED_PRICE   RSIPrice=PRICE_CLOSE;
input uint N = 7;   //  
input uint SS = 20; //  
input int Shift=0;  //      
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---
int M,tnn1,ss;
//---
double aa[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+   
//| i-SpectrAnalysis_RSI indicator initialization function           |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---     
   tnn1=int(MathPow(2,N));
   M=ArrayResize(aa,tnn1+1);
   ArraySetAsSeries(aa,true);
   ss=int(MathMin(SS,M));
   min_rates_total=int(M+RSIPeriod);
//---    iRSI
   Ind_Handle=iRSI(Symbol(),PERIOD_CURRENT,RSIPeriod,RSIPrice);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iRSI");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"i-SpecktrAnalis_RSI");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| i-SpectrAnalysis_RSI iteration function                          |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total || BarsCalculated(Ind_Handle)<rates_total) return(RESET);
//---
   for(int bar=rates_total-1; bar>=prev_calculated && !IsStopped(); bar--) IndBuffer[bar]=0.0;
//---      
   if(CopyBuffer(Ind_Handle,0,0,M,aa)<=0) return(RESET);
//---
   int end=M-1;
   fastcosinetransform(aa,tnn1,false);
   for(int kkk=0; kkk<=end && !IsStopped(); kkk++) if(kkk>=ss) aa[kkk]=0.0;
   fastcosinetransform(aa,tnn1,true);
   for(int rrr=0; rrr<=end && !IsStopped(); rrr++) IndBuffer[rrr]=aa[rrr];
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
