//+------------------------------------------------------------------+
//|                                           IncFractalsOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   Absent.

   Declaration:
   #include <IncOnArray/IncFractalsOnArray.mqh>
   CFractalsOnArray fr;

   In OnInit:
   Initialization is not required.

   In OnCalculate:
   fr.Solve(rates_total,prev_calculated,DataHigh,DataLow,UBuffer,LBuffer);
*/

//+------------------------------------------------------------------+
//| CFractalsOnArray                                                 |
//+------------------------------------------------------------------+
class CFractalsOnArray
  {
public:
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aUpper[],
              double  &aLower[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE)
              {
               if(aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
                 {
                  Start=i+8;
                  break;
                 }
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aUpper[i]=0;
         aLower[i]=0;
         double m_Pick=aDataHigh[i-2];
         double m_Trough=aDataLow[i-2];
         bool m_uf=
                   ((m_Pick>aDataHigh[i-1] && m_Pick>aDataHigh[i]) && 
                   ((m_Pick>aDataHigh[i-3] && m_Pick>aDataHigh[i-4]) || 
                   (m_Pick==aDataHigh[i-3] && m_Pick>aDataHigh[i-4] && m_Pick>aDataHigh[i-5]) || 
                   (m_Pick>=aDataHigh[i-3] && m_Pick==aDataHigh[i-4] && m_Pick>aDataHigh[i-5] && m_Pick>aDataHigh[i-6]) ||
                   (m_Pick>=aDataHigh[i-3] && m_Pick==aDataHigh[i-4] && m_Pick==aDataHigh[i-5] && m_Pick>aDataHigh[i-6] && m_Pick>aDataHigh[i-7]) ||
                   (m_Pick>=aDataHigh[i-3] && m_Pick==aDataHigh[i-4] && m_Pick>=aDataHigh[i-5] && m_Pick==aDataHigh[i-6] && m_Pick>aDataHigh[i-7] && m_Pick>aDataHigh[i-8])));
                   bool m_lf=
                   ((m_Trough<aDataLow[i-1] && m_Trough<aDataLow[i]) && 
                   ((m_Trough<aDataLow[i-3] && m_Trough<aDataLow[i-4]) || 
                   (m_Trough==aDataLow[i-3] && m_Trough<aDataLow[i-4] && m_Trough<aDataLow[i-5]) || 
                   (m_Trough<=aDataLow[i-3] && m_Trough==aDataLow[i-4] && m_Trough<aDataLow[i-5] && m_Trough<aDataLow[i-6]) ||
                   (m_Trough<=aDataLow[i-3] && m_Trough==aDataLow[i-4] && m_Trough==aDataLow[i-5] && m_Trough<aDataLow[i-6] && m_Trough<aDataLow[i-7]) ||
                   (m_Trough<=aDataLow[i-3] && m_Trough==aDataLow[i-4] && m_Trough<=aDataLow[i-5] && m_Trough==aDataLow[i-6] && m_Trough<aDataLow[i-7] && m_Trough<aDataLow[i-8])));
                   if(m_uf)
           {
            aUpper[i-2]=m_Pick;
           }
         else
           {
            aUpper[i-2]=0;
           }
         if(m_lf)
           {
            aLower[i-2]=m_Trough;
           }
         else
           {
            aLower[i-2]=0;
           }
        }
     }
   int BarsRequired()
     {
      return(9);
     }
   string Name()
     {
      return("Fractals");
     }
   string About()
     {
      return("Integer's FractalsOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
