//+------------------------------------------------------------------+
//|                                              Test_WPROnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum -100
#property indicator_maximum 0
#property indicator_buffers 4
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int      WPRPeriod=14;
//--- indicator buffers
double         WPRBuffer[];
double         DataHigh[];
double         DataLow[];
double         DataClose[];
#include <IncOnArray/IncWPROnArray.mqh>
CWPROnArray wpr;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
  
  wpr.Init(WPRPeriod);
  
//--- indicator buffers mapping
   SetIndexBuffer(0,WPRBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataLow,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataClose,INDICATOR_CALCULATIONS);  
  
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,wpr.BarsRequired());       
   PlotIndexSetString(0,PLOT_LABEL,wpr.Name());   
   
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
      if(prev_calculated>0){
         start=prev_calculated-1;
      }
      else{
         start=0;
      } 
      for(int i=start;i<rates_total;i++){
         DataHigh[i]=high[i];
         DataLow[i]=low[i];
         DataClose[i]=close[i];
      }
      
   wpr.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,WPRBuffer);     
      
   return(rates_total);
  }
//+------------------------------------------------------------------+
