//+------------------------------------------------------------------+
//|                                              Test_ADXOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 9
#property indicator_plots   3
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrLime
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//---
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrBlue
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//---
#property indicator_label3  "Label3"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrRed
#property indicator_style3  STYLE_SOLID
#property indicator_width3  1
//---
input int            ADXPeriod =  14;
input ENUM_MA_METHOD ADXMethod =  MODE_EMA;
//--- indicator buffers
double         ADXBuffer[];
double         PDIBuffer[];
double         MDIBuffer[];
double         PBuffer[];
double         MBuffer[];
double         ADXRBuffer[];
double         DataClose[];
double         DataHigh[];
double         DataLow[];
//---
#include <IncOnArray/IncADXOnArray.mqh>
CADXOnArray adx;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   adx.Init(ADXPeriod,ADXMethod);
//--- indicator buffers mapping
   SetIndexBuffer(0,ADXBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,PDIBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,MDIBuffer,INDICATOR_DATA);

   SetIndexBuffer(3,PBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,MBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,ADXRBuffer,INDICATOR_CALCULATIONS);

   SetIndexBuffer(6,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(7,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(8,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,adx.BarsRequiredADX());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,adx.BarsRequiredPDIMDI());
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,adx.BarsRequiredPDIMDI());

   PlotIndexSetString(0,PLOT_LABEL,adx.Name());
   PlotIndexSetString(1,PLOT_LABEL,adx.PDIName());
   PlotIndexSetString(2,PLOT_LABEL,adx.MDIName());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataClose[i]=close[i];
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   adx.Solve(rates_total,prev_calculated,DataClose,DataHigh,DataLow,PBuffer,MBuffer,PDIBuffer,MDIBuffer,ADXRBuffer,ADXBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
