//+------------------------------------------------------------------+
//| Class CMatrix.                                                   |
//| Purpose: Matrix operations.                                      |
//+------------------------------------------------------------------+
#define El(MATR,A,B) MATR.m[(A)*(MATR.C)+B]  // filling of matrix elements

class CMatrix
  {
public:
   short             R,C;                     // rows/cols
   double            m[];
                     CMatrix(int,int);
                    ~CMatrix();
   double            SetCell(int,int,double); // Set cell value
   double            GetCell(int,int);        // Get cell value
   void              Eq(CMatrix*);            // Copy matrix elements
   void              Tr();                    // Transpose
   void              Tr(CMatrix*);            // Transpose and copy matrix elements
   void              Mul(double x);           // Multiply by scalar
   void              Mul(CMatrix*);           // Multiply by matrix
   void              Mul(CMatrix*,CMatrix*);  // Multiply 2 matricies
   void              Add(CMatrix*);           // Add matrix
   void              Add(CMatrix*,CMatrix*);  // Add 2 matrices
   void              Sub(CMatrix*);           // Subtraction by matrix
   void              Sub(CMatrix*,CMatrix*);  // Subtract 2 matricies
   void              Unitary(void);           // Unit matrix
   void              Zero(void);              // Zero matrix
   double            Inv(void);               // Invert matrix and return determinant
  };
//+------------------------------------------------------------------+
//| CMatrix class constructor                                        |
//+------------------------------------------------------------------+
CMatrix::CMatrix(int rows,int cols)
  {
   R=(short)rows;
   C=(short)cols;
   ArrayResize(m,R*C);

  }
//+------------------------------------------------------------------+
//| CMatrix class destructor                                         |
//+------------------------------------------------------------------+
CMatrix::~CMatrix()
  {
  ArrayResize(m,0);
  }
//+------------------------------------------------------------------+
//| SetCell                                                          |
//+------------------------------------------------------------------+
double CMatrix::SetCell(int row,int col,double value)
  {
   if(row>=R || col>=C) return 0;
   else
     {
      m[row*C+col]=value;
      return 1;
     }
  }
//+------------------------------------------------------------------+
//| GetCell                                                          |
//+------------------------------------------------------------------+
double CMatrix::GetCell(int row,int col)
  {
   if(row>=R || col>=C) return 0;
   else return m[row*C+col];

  }
//+------------------------------------------------------------------+
//| Eq                                                               |
//+------------------------------------------------------------------+
void CMatrix::Eq(CMatrix *M)
  {
   if(R==M.R && C==M.C)
      for(int i=0; i<R*C; i++)
         m[i]=M.m[i];
  }
//+------------------------------------------------------------------+
//| Zero                                                             |
//+------------------------------------------------------------------+
void CMatrix::Zero(void)
  {
   for(int i=0;i<(R*C); i++)
      m[i]=0;
  }
//+------------------------------------------------------------------+
//| Tr                                                               |
//+------------------------------------------------------------------+
void CMatrix::Tr()
  {
   short a=R;
   R=C;
   C=a;

   double tmp[];
   ArrayResize(tmp,R*C);

   for(char i=0; i<R; i++)
      for(char j=0; j<C; j++)
         tmp[i*C+j]=El(this,j,i);

   for(int i=0;i<(R*C); i++)
      m[i]=tmp[i];
  }
//+------------------------------------------------------------------+
//| Tr                                                               |
//+------------------------------------------------------------------+
void CMatrix::Tr(CMatrix *M)
  {
   R=M.C; C=M.R;
   for(char i=0; i<R; i++)
      for(char j=0; j<C; j++)
         m[i*C+j]=El(M,j,i);

  }
//+------------------------------------------------------------------+
//| Unitary                                                          |
//+------------------------------------------------------------------+
void CMatrix::Unitary(void)
  {
   Zero();
   for(char i=0; i<R; i++)
      for(char j=0; j<C; j++)
         if(R==C) El(this,i,j)=1;

  }
//+------------------------------------------------------------------+
//| Add                                                              |
//+------------------------------------------------------------------+
void CMatrix::Add(CMatrix *M1,CMatrix *M2)
  {
   for(int i=0;i<(R*C); i++)
      m[i]=M1.m[i]+M2.m[i];
  }
//+------------------------------------------------------------------+
//| Add                                                              |
//+------------------------------------------------------------------+
void CMatrix::Add(CMatrix *M1)
  {
   for(int i=0;i<(R*C); i++)
      m[i]+=M1.m[i];
  }
//+------------------------------------------------------------------+
//| Sub                                                              |
//+------------------------------------------------------------------+
void CMatrix::Sub(CMatrix *M1,CMatrix *M2)
  {
   for(int i=0;i<(R*C); i++)
      m[i]=M1.m[i]-M2.m[i];
  }
//+------------------------------------------------------------------+
//| Sub                                                              |
//+------------------------------------------------------------------+
void CMatrix::Sub(CMatrix *M1)
  {
   for(int i=0;i<(R*C); i++)
      m[i]-=M1.m[i];
  }
//+------------------------------------------------------------------+
//| Mul                                                              |
//+------------------------------------------------------------------+
void CMatrix::Mul(double x)
  {
   for(int i=0;i<(R*C); i++)
      m[i]*=x;
  }
//+------------------------------------------------------------------+
//| Mul                                                              |
//+------------------------------------------------------------------+
void CMatrix::Mul(CMatrix *M2)
  {
   if(C!=M2.R) return;
   C=M2.C;

   double tmp[];
   ArrayResize(tmp,R*C);

   for(int k=0;k<R;k++)
      for(int i=0;i<C;i++)
        {
         tmp[k*C+i]=0;
         for(int j=0;j<M2.R;j++)
            tmp[k*C+i]+=El(this,k,j)*El(M2,j,i);
        }

   for(int i=0;i<(R*C); i++)
      m[i]=tmp[i];
  }
//+------------------------------------------------------------------+
//| Mul                                                              |
//+------------------------------------------------------------------+
void CMatrix::Mul(CMatrix *M1,CMatrix *M2)
  {
   if(M1.C!=M2.R) return;

   R=M1.R;
   C=M2.C;
   Zero();

   for(int k=0;k<R;k++)
      for(int i=0;i<C;i++)
         for(int j=0;j<M2.R;j++)
            El(this,k,i)+=El(M1,k,j)*El(M2,j,i);
  }
//+------------------------------------------------------------------+
//| Inv                                                              |
//+------------------------------------------------------------------+
double CMatrix::Inv(void)
  {
   if(R!=C) return 0;

   CMatrix *MTmp=new CMatrix(R,2*R);
   CMatrix *NTmp=new CMatrix(R,2*R);

   for(int i=0;i<R;i++)
      for(int j=0;j<R;j++)
         MTmp.m[j+i*2*R]=m[j+i*R];

   double det=1;
   int mov=R-1;

   for(int i=0;i<R;i++)
      for(int j=R;j<R+R;j++)
         if(i==j-R) MTmp.m[i*2*R+j]=1;
   else MTmp.m[i*2*R+j]=0;

   for(int k=0;k<R-1;k++)
     {
      if(mov>0)
         det*=MTmp.m[k*2*R+k];

      for(int j=R+mov;j>k-1;j--)
         MTmp.m[k*2*R+j]=MTmp.m[k*2*R+j]/MTmp.m[k*2*R+k];

      for(int i=k+1;i<R;i++)
         for(int j=R+mov;j>k-1;j--)
            MTmp.m[i*2*R+j]=MTmp.m[i*2*R+j]-MTmp.m[k*2*R+j]*MTmp.m[i*2*R+k];
     }

   if(mov>0)
      det*=MTmp.m[(R-1)*2*R+R-1];

   if(det)
     {
      for(int quan=0;quan<R;quan++)
        {
         NTmp.m[quan*2*R+(R-1)]=MTmp.m[(R-1)*2*R+R+quan]/MTmp.m[(R-1)*2*R+R-1];
         for(int k=1;k<R;k++)
           {
            double curr=MTmp.m[(R-k-1)*2*R+R+quan];
            for(int i=R-1;i>=R-k;i--)
               curr-=MTmp.m[(R-k-1)*2*R+i]*NTmp.m[(quan)*2*R+i];
            NTmp.m[(quan)*2*R+R-k-1]=curr;
           }
        }
     }

   for(int i=0;i<R;i++)
      for(int j=0;j<R;j++)
         m[i*R+j]=NTmp.m[j*2*R+i];

   delete MTmp;
   delete NTmp;

   return det;
  }
//+------------------------------------------------------------------+
