//+------------------------------------------------------------------+
//|                                              Expert_Test_PNG.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <Canvas\png.mqh>
#include <Canvas\iCanvas_CB.mqh> // https://www.mql5.com/ru/code/22164
#resource "//Images//icons.png" as uchar png_data[]
//+------------------------------------------------------------------+
CPng png1(png_data);                   // Get the PNG from the resource, unpack it into a bitmap array bmp[] and don't create the canvas yet
CPng png2("cubes.png",true, 0, 100); // Get PNG from a file, create a canvas and display it on the screen at coordinates (X=0, Y=100)
//+------------------------------------------------------------------+
int OnInit() {
   png1.Resize(600);
   png1._CreateCanvas(700,150);
   png1.Resize(W.Width/6);
   png2.Resize(220);
   png2._CreateCanvas(W.MouseX, W.MouseY);


   png1.BmpArrayFree();
   EventSetMillisecondTimer(30);
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason) {
   EventKillTimer();
}
//+------------------------------------------------------------------+
void OnTick() {
}
//+------------------------------------------------------------------+
void OnTimer() {
   static double angle = 0;
   DrawIcons(angle);
   angle+=0.06;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam) {
   if (id == CHARTEVENT_MOUSE_MOVE) {
      png2._MoveCanvas(W.MouseX, W.MouseY);
      png2.MoveCanvas(W.MouseX/10, 100+W.MouseY/10);
      png1._MoveCanvas(700+W.MouseX/16, 150+W.MouseY/16);
   }
}
//+------------------------------------------------------------------+
void DrawIcons (double angle) {
   Canvas.Erase(0);
   double dx = png1._width/8.0;
   double dy = png1._height/6.0;
   for (int x = 0; x<8; x++)
      for (int y = 0; y<6; y++) {
         int i = y*8+x;
         int X = (i+1)*W.Width/50;
         int Y = 60+Round(sin(angle+X*20.0/W.Width)*50);
         int adr = int(y*dy)*png1._width + int(x*dx);
         for (int h = 0; h<dy; h++) ArrayCopy(Canvas.m_pixels,png1._bmp,(Y+h)*W.Width+X,adr+h*png1._width,int(dx));
      }
   Canvas.Update();
}
//+------------------------------------------------------------------+
