//+------------------------------------------------------------------+
//|                                        TestRSIZZXOnRSIBuffer.mq5 |
//|                           Copyright 2021, Tobias Johannes Zimmer |
//|                                 https://www.mql5.com/pennyhunter |
//+------------------------------------------------------------------+
#property copyright "Copyright 2021, Tobias Johannes Zimmer"
#property link      "https://www.mql5.com/pennyhunter"
#property version   "1.00"
#include  <ZigZagExtremaOnBuffer.mqh>
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1  30
#property indicator_level2  70
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_label1  "RSI"
#property indicator_type1   DRAW_LINE
#property indicator_style1  STYLE_SOLID
#property indicator_color1  clrTomato
#property indicator_width1  2

#property indicator_label2  "ZigZag"
#property indicator_type2   DRAW_SECTION
#property indicator_style2  STYLE_SOLID
#property indicator_color2  clrDodgerBlue
#property indicator_width2  2

//--- input parameters
input int                  InpPeriodRSI      = 8;              // Period
input ENUM_APPLIED_PRICE   InpAppliedPrice   = PRICE_CLOSE;    // Applied Price
input int                  InpDepth          = 12;             // Depth
input int                  InpDeviation      = 5;              // Deviation
input int                  InpBackstep       = 3;              // Back Step
input EnSearchMode         InpSearchMode     = Bottom;       // Search mode

//--- indicator buffers
double    ExtOutputBuffer[];
double    ExtRSIBuffer[];
//--- handles
int RSIHandle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit() {
//--- indicator buffers mapping

   SetIndexBuffer(0, ExtRSIBuffer, INDICATOR_DATA);
   SetIndexBuffer(1, ExtOutputBuffer, INDICATOR_DATA);


   RSIHandle = iRSI(_Symbol, _Period, InpPeriodRSI, InpAppliedPrice);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0.0);

//---
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]) {
//---

   int to_copy = (rates_total - prev_calculated) * (prev_calculated < rates_total) + (1) * (prev_calculated == rates_total);
   CopyBuffer(RSIHandle, 0, 0, to_copy, ExtRSIBuffer);

   ZZOnBuffer(rates_total, prev_calculated, ExtRSIBuffer, ExtOutputBuffer, InpSearchMode, InpDepth, InpDeviation, InpBackstep);



//--- return value of prev_calculated for next call
   return(rates_total);
}
//+------------------------------------------------------------------+
