//+------------------------------------------------------------------+
//|                                               InnerBarSignal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
//+------------------------------------------------------------------+
//| include files                                                    |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signal based on inner bar breakthrough in trend direction  |
//| Type=SignalAdvanced                                              |
//| Name=InnerBar                                                    |
//| Class=CInnerBarSignal                                            |
//| Page=                                                            |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| CInnerBarSignal class                                            |
//| Purpose: A class of a module of trade signals,                   |
//| on inner bar breakthrough in trend direction                     |
//+------------------------------------------------------------------+
class CInnerBarSignal : public CExpertSignal
  {
public:
   virtual int       ShortCondition();      //checks conditions for sell
   virtual int       LongCondition();       //checks conditions for buy
   void CInnerBarSignal(){ m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;  }
  };
//+------------------------------------------------------------------+
//| Checks conditions for sell                                       |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CInnerBarSignal::ShortCondition()
  {
//--- checks sell conditions for last completed bar
   if(Low(1)<Low(2) && High(2)<High(3) && Low(2)>Low(3) && Close(3)<Open(3))
     {
      return(100);
     }
//--- condition is not satisfied
   return(0);
  }
//+------------------------------------------------------------------+
//| Checks conditions for buy                                        |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CInnerBarSignal::LongCondition()
  {
//--- checks buy conditions for last completed bar
   if(High(1)>High(2) && Low(2)>Low(3) && High(2)<High(3) && Close(3)>Open(3))
     {
      return(100);
     }
//--- condition is not satisfied
   return(0);
  }

//+------------------------------------------------------------------+
