//+------------------------------------------------------------------+
//|                                                    Functions.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| load all positions tickets from terminal                         |
//+------------------------------------------------------------------+
int PositionsLoad(ulong& dst_tickets[],string symbol)
  {
   int total=PositionsTotal(),count=0;
   for(int i=0; i<total; i++)
     {
      ulong iticket=PositionGetTicket(i);
      if(!iticket || PositionGetString(POSITION_SYMBOL)!=symbol)
         continue;
      //---append ticket
      int size=ArraySize(dst_tickets);
      ArrayResize(dst_tickets,size+1,size*2);
      dst_tickets[size]=iticket;
      count++;
     }
   return count;
  }


//+------------------------------------------------------------------+
//| positions print                                                  |
//+------------------------------------------------------------------+
void PositionsPrint(ulong& tickets[],int digits)
  {
   int total=ArraySize(tickets);
//---header
   printf("---%d tickets as of %s",total,TimeToString(TimeCurrent()));
//---body
   for(int i=0; i<total; i++)
     {
      if(!PositionSelectByTicket(tickets[i]))
         continue;
      //---data
      string symbol=PositionGetString(POSITION_SYMBOL);
      double open=PositionGetDouble(POSITION_PRICE_OPEN);
      //---out
      printf("%8s | %13I64u | %8s",symbol,tickets[i],DoubleToString(open,digits));
     }
  }


//+------------------------------------------------------------------+
//| sort keys                                                        |
//+------------------------------------------------------------------+
#include "ASorter.mqh"
template<typename TKey>
void ArraySort(TKey& keys[],ASorter<TKey,TKey>* sorter,bool accending_order=true)
  {
//---prepare sorter
   ArrayCopy(sorter.keys,keys);
//---sort keys
   sorter.Sort();
//---save sorted keys
   ArrayCopy(keys,sorter.keys);
//---keep order
   if(!accending_order)
      ArrayReverse(keys);
//---clear
   if(CheckPointer(sorter)==POINTER_DYNAMIC)
      delete sorter;
  }

//+------------------------------------------------------------------+
