//+------------------------------------------------------------------+
//|                                                    MergeSort.mq5 |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//   mergesort - a merging method sorting algorithm
//
//   merge sort is an efficient, general-purpose, comparison-based
//sorting algorithm. most implementations produce a stable sort,
//which means that the order of equal elements is the same in the
//input and output. merge sort is a divide and conquer algorithm that
//was invented by john von neumann in 1945.
//   merge sort takes advantage of the ease of merging already sorted
//lists into a new sorted list. it starts by comparing every two
//elements (i.e., 1 with 2, then 3 with 4...) and swapping them if
//the first should come after the second. it then merges each of the
//resulting lists of two into lists of four, then merges those lists
//of four, and so on; until at last two lists are merged into the
//final sorted list. this algorithm scales well to very large lists,
//because its worst-case running time is o(n log n). it is also
//easily applied to lists, not only arrays, as it only requires
//sequential access, not random access. however, it has additional
//o(n) space complexity, and involves a large number of copies in
//simple implementations.
//   merge sort is used in the sophisticated algorithm timsort, which 
//is used for the standard sort routine in the programming languages 
//python and java. merge sort itself is the standard routine in perl, 
//among others, and has been used in java.
//   cases: best - n log n, average - n log n, worst - n log n 
//   memory - n, stability - yes, method - merging
//
//+------------------------------------------------------------------+
//| merge sort example - sort positions by ticket number             |
//+------------------------------------------------------------------+
#include <Mqh\Algorithms\MergeSort\ASorter.mqh>
#include <Mqh\Algorithms\MergeSort\MergeSort.mqh>
#include <Mqh\Algorithms\MergeSort\Functions.mqh>
void OnStart(void)
  {
//---load tickets from terminal
   string symbol=_Symbol;
   ulong tickets[];
   PositionsLoad(tickets,symbol);
//---sort tickets by number in accending order
   ArraySort(tickets,new CMergeSort<ulong,ulong>);
//---print tickets
   PositionsPrint(tickets,(int)SymbolInfoInteger(symbol,SYMBOL_DIGITS));
  }
//
//   output
//
//      TSLA |     202127461 |   566.46
//      TSLA |     202127496 |   567.00
//      TSLA |     202128932 |   574.70
//      TSLA |     202147120 |   600.33
//      TSLA |     202149635 |   598.14
//      TSLA |     202185008 |   616.92
//   ...
//+------------------------------------------------------------------+
