//+------------------------------------------------------------------+
//|                                                    Functions.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| load all positions tickets from terminal                         |
//+------------------------------------------------------------------+
int PositionsLoad(ulong& dst_tickets[],string symbol)
  {
   int total=PositionsTotal(),count=0;
   for(int i=0; i<total; i++)
     {
      ulong iticket=PositionGetTicket(i);
      if(!iticket || PositionGetString(POSITION_SYMBOL)!=symbol)
         continue;
      //---append ticket
      int size=ArraySize(dst_tickets);
      ArrayResize(dst_tickets,size+1,size*2);
      dst_tickets[size]=iticket;
      count++;
     }
   return count;
  }


//+------------------------------------------------------------------+
//| create keys array with position open prices                      |
//+------------------------------------------------------------------+
void PositionsKeysPriceOpen(ulong& tickets[],double& keys[])
  {
   int total=ArraySize(tickets);
   ArrayResize(keys,total);
   for(int i=0; i<total; i++)
     {
      double iopen=0;
      if(PositionSelectByTicket(tickets[i]))
         iopen=PositionGetDouble(POSITION_PRICE_OPEN);
      //---append key
      keys[i]=iopen;
     }
  }


//+------------------------------------------------------------------+
//| positions print                                                  |
//+------------------------------------------------------------------+
void PositionsPrint(ulong& tickets[],int digits)
  {
   int total=ArraySize(tickets);
   for(int i=0; i<total; i++)
     {
      if(!PositionSelectByTicket(tickets[i]))
         continue;
      //---data
      string symbol=PositionGetString(POSITION_SYMBOL);
      double open=PositionGetDouble(POSITION_PRICE_OPEN);
      //---out
      printf("%8s | %8u | %8s",symbol,tickets[i],DoubleToString(open,digits));
     }
  }


//+------------------------------------------------------------------+
