//+------------------------------------------------------------------+
//|                                               TemplateMethod.mq5 |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//
//   template method - behavioral design pattern
//
//   from: design patterns: elements of reusable object-oriented software
//   by gof: erich gamma, richard helm, ralph johnson, john vlissides
//   published in 1994
//
//   intent
//   
//   define the skeleton of an algorithm in an operation, deferring some 
//steps to subclasses. template method lets subclasses redefine certain 
//steps of an algorithm without changing the algorithm's structure
//
//   structure
//      
//                  |    AbstractClass     |
//                  |----------------------|
//                  |TemplateMethod()      |
//                  | ...                  |
//                  | PrimitiveOperation1()|
//                  | ...                  |
//                  | PrimitiveOperation2()|
//                  | ...                  |
//                  |PrimitiveOperation1() |
//                  |PrimitiveOperation2() |
//                             ^
//                             |
//                  |    ConcreteClass    |
//                  |---------------------|
//                  |PrimitiveOperation1()|
//                  |PrimitiveOperation2()|
//      
//   applicability
//
//   the template method pattern should be used
//      to implement the invariant parts of an algorithm once and leave 
//it up to subclasses to implement the behavior that can vary
//      when common behavior among subclasses should be factored and 
//localized in a common class to avoid code duplication. this is a good 
//example of "refactoring to generalize". you first identify the differences 
//in the existing code and then separate the differences into new operations. 
//finally, you replace the differing code with a template method that 
//calls one of these new operations
//      to control subclasses extensions. you can define a template method 
//that calls "hook" operations (see consequences) at specific points, 
//thereby permitting extensions only at those points
//
//   participants
//
//   abstract class 
//      defines abstract primitive operations that concrete subclasses 
//define to implement steps of an algorithm
//      implements a template method defining the skeleton of an algorithm. 
//the template method calls primitive operations as well as operations 
//defined in abstract class or those of other objects
//   concrete class 
//      implements the primitive operations to carry out subclass-specific 
//steps of the algorithm
//
//   collaborations
//
//   concrete class relies on abstract class to implement the invariant 
//steps of the algorithm
//
//+------------------------------------------------------------------+
//|                                              example of a client |
//+------------------------------------------------------------------+
#include <Mqh\Patterns\Template Method\AbstractClass.mqh>
#include <Mqh\Patterns\Template Method\ConcreteClass.mqh>
void OnStart()
  {
   AbstractClass* instance=new ConcreteClass();
   instance.TemplateMethod();
   delete instance;
  }
//
//   output
//
//   abstract template method requested
//   executing concrete primitive operation 1
//   executing concrete primitive operation 2
//   
//   consequences
//
//   template methods are a fundamental technique for code reuse. they 
//are particularly important in class libraries, because they are the 
//means for factoring out common behavior in library classes.
//   template methods lead to an inverted control structure that's sometimes 
//referred to as "the hollywood principle," that is, "don't call us, we'll 
//call you". this refers to how a parent class calls the operations of 
//a subclass and not the other way around.
//   template methods call the following kinds of operations:
//      concrete operations (either on the concrete class or on client 
//classes);
//      concrete abstract class operations (i.e., operations that are 
//generally useful to subclasses);
//      primitive operations (i.e., abstract operations);
//      factory methods and
//      hook operations, which provide default behavior that subclasses 
//can extend if necessary. a hook operation often does nothing by default
//
//   implementation
//
//   three implementation issues are worth noting:
//      using c++ access control
//         in c++, the primitive operations that a template method calls 
//can be declared protected members. this ensures that they are only called 
//by the template method. primitive operations that must be overridden 
//are declared pure virtual. the template method itself should not be 
//overridden; therefore you can make the template method a nonvirtual 
//member function. 
//      minimizing primitive operations
//         an important goal in designing template methods is to minimize 
//the number of primitive operations that a subclass must override to 
//flesh out the algorithm. the more operations that need overriding, the 
//more tedious things get for clients.
//      naming conventions
//         you can identify the operations that should be overridden by 
//adding a prefix to their names. for example, refix template method names 
//with "do-": "docreatedocument", "doread", and so forth.
//
//   related patterns
//
//   factory methods are often called by template methods
//   strategy: template methods use inheritance to vary part of an algorithm. 
//strategies use delegation to vary the entire algorithm
//
//+------------------------------------------------------------------+
