//+------------------------------------------------------------------+
//|                                                201111_084512.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
#include <Mqh\201111_084634.mqh> //push observer

//+------------------------------------------------------------------+
//| subject                                                          |
//+------------------------------------------------------------------+
class Subject
  {
public:
                     Subject(void);
                    ~Subject(void);

   void              Attach(Observer* observer);
   void              Detach(Observer& observer);
   void              Notify(void);
   void              State(string state);
   string            State(void) {return m_state;}

protected:
   string            m_state;
   Observer*         m_observers[];

   int               Find(Observer& observer);
  };


//+------------------------------------------------------------------+
//| constructor                                                      |
//+------------------------------------------------------------------+
Subject::Subject(void):
   m_state(NULL)
  {
  }


//+------------------------------------------------------------------+
//| destructor                                                       |
//+------------------------------------------------------------------+
Subject::~Subject(void)
  {
   int itotal=ArraySize(m_observers);
   for(int i=0; i<itotal; i++)
     {
      Observer* item=m_observers[i];
      //---delete
      if(CheckPointer(item)==1)
        {
         delete item;
        }
     }
  }


//+------------------------------------------------------------------+
//| state                                                            |
//+------------------------------------------------------------------+
void Subject::State(string state)
  {
   m_state=state;
   Print("subject state set to: ",state);
  }


//+------------------------------------------------------------------+
//| notify                                                           |
//+------------------------------------------------------------------+
void Subject::Notify(void)
  {
   int itotal=ArraySize(m_observers);
   for(int i=0; i<itotal; i++)
     {
      Print("pushing state to observer ",m_observers[i],"...");
      m_observers[i].Update(m_state);
     }
  }


//+------------------------------------------------------------------+
//| attach                                                           |
//+------------------------------------------------------------------+
void Subject::Attach(Observer *observer)
  {
   int size=ArraySize(m_observers);
   ArrayResize(m_observers,size+1);
   m_observers[size]=observer;
  }


//+------------------------------------------------------------------+
//| detach                                                           |
//+------------------------------------------------------------------+
void Subject::Detach(Observer &observer)
  {
   int find=Find(observer);
   if(find==-1)
      return;
   Observer* item=m_observers[find];
//---delete
   if(CheckPointer(item)==1)
      delete item;
   ArrayRemove(m_observers,find,1);
  }


//+------------------------------------------------------------------+
//| find                                                             |
//+------------------------------------------------------------------+
int Subject::Find(Observer &observer)
  {
   int itotal=ArraySize(m_observers);
   for(int i=0; i<itotal; i++)
     {
      Observer* item=m_observers[i];
      if(item==&observer)
         return i;
     }
   return -1;
  }

//+------------------------------------------------------------------+
