//+------------------------------------------------------------------+
//|                                                  DynamicRS_C.mq5 |
//|                                 Copyright  2007, Nick A. Zhilin |
//|                                                  rebus58@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Nick A. Zhilin"
#property link "rebus58@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---   
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1  clrMagenta,clrYellow,clrBlueViolet
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "DynamicRS_C"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Length=5;     //    
input int Shift=0;       //      
input int PriceShift=0;  //      
//+-----------------------------------+
//---   ,    
//---      
double IndBuffer[];
double ColorIndBuffer[];
//---      
double dPriceShift;
//---      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=int(Length+1);
//---    
   dPriceShift=_Point*PriceShift;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   string shortname;
//---      
   StringConcatenate(shortname,"DynamicRS_C(",Length,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total-1; //      
      IndBuffer[first-1]=close[first-1];
      ColorIndBuffer[first-1]=1;
     }
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      ColorIndBuffer[bar]=1;
      if(high[bar]<high[bar-1] && high[bar]<high[bar-Length] && high[bar]<IndBuffer[bar-1])
        {
         IndBuffer[bar]=high[bar]+PriceShift;
         if(ColorIndBuffer[bar-1]==2) ColorIndBuffer[bar]=1; else ColorIndBuffer[bar]=0;
        }
      else if(low[bar]>low[bar-1] && low[bar]>low[bar-Length] && low[bar]>IndBuffer[bar-1])
        {
         IndBuffer[bar]=low[bar]+PriceShift;
         if(ColorIndBuffer[bar-1]==0) ColorIndBuffer[bar]=1; else ColorIndBuffer[bar]=2;
        }
      else
        {
         IndBuffer[bar]=IndBuffer[bar-1];
         ColorIndBuffer[bar]=ColorIndBuffer[bar-1];
         if(ColorIndBuffer[bar]==1)
           {
            if(ColorIndBuffer[bar-2]==0) ColorIndBuffer[bar]=2;
            if(ColorIndBuffer[bar-2]==2) ColorIndBuffer[bar]=0;
           }
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
