//+---------------------------------------------------------------------+
//|                                                        DEMA_RLH.mq5 | 
//|                                       Copyright  2006, Robert Hill | 
//|                                          http://www.metaquotes.net/ | 
//+---------------------------------------------------------------------+ 
//| Place the SmoothAlgorithms.mqh file                                 |
//| in the directory: terminal_data_folder\MQL5\Include                 |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, Robert Hill"
#property link "http://www.metaquotes.net/"
//--- Indicator version
#property version   "1.00"
//--- drawing the indicator in the main window
#property indicator_chart_window 
//--- number of indicator buffers 4
#property indicator_buffers 4 
//--- two plots are used
#property indicator_plots   2
//+----------------------------------------------+
//|  Indicator 1 drawing parameters              |
//+----------------------------------------------+
//--- drawing the indicator as a colored cloud
#property indicator_type1   DRAW_FILLING
//--- the following colors are used for the indicator
#property indicator_color1  clrLime,clrRed
//--- displaying the indicator label
#property indicator_label1 "Up;Down"
//+----------------------------------------------+
//|  Indicator 2 drawing parameters              |
//+----------------------------------------------+
//--- drawing the indicator as a colored cloud
#property indicator_type2   DRAW_FILLING
//--- the following colors are used for the indicator
#property indicator_color2  clrGreenYellow,clrOrange
//--- displaying the indicator label
#property indicator_label2 "Up;Down"
//+----------------------------------------------+
//|  CXMA class description                      |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//--- declaration of the CXMA class variables from the SmoothAlgorithms.mqh file
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|  declaration of enumerations                 |
//+----------------------------------------------+
enum Applied_price_      // type of constant
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE_,        // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price
   PRICE_DEMARK_         // Demark Price
  };
//+----------------------------------------------+
//| Indicator input parameters                 |
//+----------------------------------------------+
input Smooth_Method MA_Method1=MODE_EMA; // Method of averaging of the first smoothing
input int Length1=14;                    // Depth of the first smoothing
input int Phase1=15;                     // Parameter of the first smoothing
//--- Phase1: for JJMA it varies within the range -100 ... +100 and influences the quality of the transient period;
//--- Phase1: for VIDIA it is a CMO period, for AMA it is a slow average period
input Smooth_Method MA_Method2=MODE_EMA; // Method of averaging of the second smoothing 
input int Length2 = 5;                   // Depth of the second smoothing 
input int Phase2=15;                     // Parameter of the second smoothing
//--- Phase2: for JJMA it varies within the range -100 ... +100 and influences the quality of the transient period;
//--- Phase2: for VIDIA it is a CMO period, for AMA it is a slow average period
input Applied_price_ IPC=PRICE_CLOSE;    // Price constant
input int Shift=0;                       // Horizontal shift of the indicator in bars
//+----------------------------------------------+
//--- declaration of dynamic arrays that
//--- will be used as indicator buffers
double Up1IndBuffer[],Dn1IndBuffer[];
double Up2IndBuffer[],Dn2IndBuffer[];
//--- declaration of integer variables for the start of data calculation
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+   
//| DEMA_RLH indicator initialization function                       | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//--- initialization of variables of data calculation start
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=min_rates_1+min_rates_2;
//--- setting up alerts for unacceptable values of external variables
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//--- setting up alerts for unacceptable values of external variables
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);
//--- Initialize indicator buffers
   IndInit(0,Up1IndBuffer,INDICATOR_DATA);
   IndInit(1,Dn1IndBuffer,INDICATOR_DATA);
   IndInit(2,Up2IndBuffer,INDICATOR_DATA);
   IndInit(3,Dn2IndBuffer,INDICATOR_DATA);
//--- initialization of indicators
   PlotInit(0,0.0,min_rates_total,Shift);
   PlotInit(1,0.0,min_rates_total,Shift);
//--- initializations of a variable for the indicator short name
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"DEMA_RLH(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//--- determining the accuracy of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//--- initialization end
  }
//+------------------------------------------------------------------+ 
//| DEMA_RLH iteration function                                      | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- checking if the number of bars is enough for the calculation
   if(rates_total<min_rates_total) return(0);
//--- declaration of variables with a floating point  
   double price,x1xma,x2xma,dxma;
//--- declaration of integer variables and getting already calculated bars
   int first,bar;
//--- calculation of the 'first' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of calculation of an indicator
      first=0; // starting index for calculation of all bars
   else first=prev_calculated-1; // starting number for calculation of new bars
//--- main indicator calculation loop
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //--- call of the PriceSeries function to get the input price 'price'
      price=PriceSeries(IPC,bar,open,low,high,close);
      //---- two calls of the XMASeries function. 
      //--- the 'begin' parameter in the second call is increased by min_rates_, t. e. this is a repeated XMA smoothing  
      x1xma=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      x2xma=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2,Phase2,Length2,x1xma,bar,false);
      dxma=2*x1xma-x2xma;
      //---
      Up1IndBuffer[bar]=dxma;
      Dn1IndBuffer[bar]=x1xma;
      //---
      Up2IndBuffer[bar]=x1xma;
      Dn2IndBuffer[bar]=x2xma;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Indicator buffer initialization                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//--- Set dynamic array as an indicator buffer
   SetIndexBuffer(Number,Buffer,Type);
//---
  }
//+------------------------------------------------------------------+
//| indicator initialization                                         |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//--- shifting the start of drawing of the indicator
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//--- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//--- shifting the indicator horizontally by Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
