//+------------------------------------------------------------------+
//|                                                   DoubleTest.mq5 |
//|                                      Copyright 2017, nicholishen |
//|                         https://www.forexfactory.com/nicholishen |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, nicholishen"
#property link      "https://www.forexfactory.com/nicholishen"
#property version   "1.00"
//--- script for debugging !!!Save as .mq4 to test with mql4
#include <Double.mqh>

void OnStart()
{  
   {
   Print("CDouble size = ",sizeof(CDouble)," bytes");
   
   // simple static methods.
   MqlTick tick;
   SymbolInfoTick(_Symbol,tick);
   double rnd_by_point  = CDouble::RoundToStep(tick.bid*1.052565465,_Point);
   double rnd_by_digits = CDouble::RoundToDigit(tick.bid*1.052565465,_Digits);
   double by_lot_step   = CDouble::RoundToLots(0.123423,_Symbol);
   double by_tick_size  = CDouble::RoundToTick(tick.ask-100*_Point,_Symbol);
   double roundup       = CDouble::RoundToStepUp(3.999999999,_Point);
   double rounddn       = CDouble::RoundToStepDown(3.999999999,_Point);
   int    digits        = CDouble::GetDigits(0.0000025);
   double point         = CDouble::GetPoint(10);
   bool   equal         = CDouble::IsEqual(tick.bid,tick.bid+0.00000009,_Point);
   string tostr         = CDouble::ToString(3.1399999999999999);
   int    compare       = CDouble::Compare(tick.ask,tick.bid);
   
#ifdef __MQL5__
   MqlTradeRequest r={0};
   r.symbol= _Symbol;
   r.price = tick.ask+0.000089849847658759198199999;
   r.sl    = r.price - 503 * _Point;
   r.tp    = r.price + 503 * _Point;
   r.volume= 1.127984984;
   
   CDouble::RoundTradeRequest(r);
#endif 



   // default precision of 8 digits. Symbol is == ChartSymbol
   CDouble pi;
   // default constructor immediately followed by overloaded assignment operator to assign double value
   CDouble pi2 = 3.141596846846848;
   // overload constructor defines precision mode and symbol for tick/lot calculations.
   CDouble pi3(PRECISION_TICK_SIZE,_Symbol);
   // copy constructor: copies all class attributes without need to specify precision parameters.
   CDouble pi4 = pi3;
   CDouble pi5 = 3.14;
   CDouble factor = 2;
   pi5*=factor;
   Print(pi5.ToString());
  
   CDouble foo    = 3.14;
   CDouble bar    = 10;
   CDouble foobar = bar + foo;          //13.14
   Print(foobar.ToString());
   double value = bar / foo;
   Print(value);
   //CDouble err    = bar + foo + foobar; //error - illegal operation use
   
   
   
   // getting value as... 
   double raw_double             = pi2.AsRawDouble();
   double round_double_to_step   = pi2.AsRounded();
   double tick_size_double       = pi2.AsRoundedTick();
   double lot_step_double        = pi2.AsRoundedLots();
   double rounded_up             = pi2.AsRoundedUp();
   double rounded_down           = pi2.AsRoundedDown();
   int    double_to_int          = pi2.ToInt();
   long   double_to_long         = pi2.ToLong();
   string precision_str          = pi2.ToStringPrecision();
   pi2 = 3.140000000009;
   pi2.Digits(8);
   string truncated_str          = pi2.ToString();
   
   // overloaded arithmatic operators
   pi = pi2 * 2 ;
   Print(pi.ToString());
   // overloaded assignment operators
   pi /= 2;
   Print(pi.ToString());
   // overloaded relation operator
   Print(pi == pi2);
   Print(pi == 3.14000000007);
   // not using overloaded operator
   Print(pi.AsRawDouble() == 3.14000000007);
   Print(pi <= pi2);
   Print(pi >  pi2);
   
   //DoubleVector
   CDoubleVector *vect = new CDoubleVector;
   
   //assigning array of primative doubles to convert to vector of CDouble objects
   double dubs[]={3.14,1.21,55.555};
   vect.AssignDoubleArray(dubs);
   
   //convert primative doubles to CDouble and add to the end of the collection
   vect.Add(tick.bid);
   
   //calling CDouble object by index
   Print(vect[vect.Total()-1].ToString());
   
   //add a new CDouble object
   CDouble *lot = new CDouble(PRECISION_LOT_STEP);
   lot = 1.22;
   vect.Add(lot);
   
   //sort vector ascending
   vect.Sort();
   
   int total = vect.Total();
   
   //save vector to file including CDouble object states and values
   string f = "testdub.bin";
   int    h = FileOpen(f,FILE_WRITE|FILE_BIN);
   if(vect.Save(h))
      Print("save successful");
   FileClose(h);
   delete vect;
   
   //load vector from file
   CDoubleVector vect_reborn;
   h=FileOpen(f,FILE_READ|FILE_BIN);
   if(vect_reborn.Load(h))
      Print("load successful");
   FileClose(h);
   total = vect_reborn.Total();
   Print("Total vector size = ",sizeof(vect_reborn)," bytes");
   for(int i=0;i<vect_reborn.Total();i++)
      Print(vect_reborn[i].ToString());
      
   //Copy out to double arr
   double arr2[];
   vect_reborn.CopyOut(arr2);
   Print(ArraySize(arr2));
   }
   {
  
   MqlTick tick;
   SymbolInfoTick(_Symbol,tick);
   CDouble  price = tick.ask - 0.0087263487676283476,
            sl= price - 500*_Point,
            tp= price + 500*_Point,
            lots = 5.25 / 3.78789;
   MqlTradeRequest r={0};
   r.symbol= _Symbol;
   r.price = price.AsRoundedTick();
   r.sl    = sl.AsRoundedTick();
   r.tp    = tp.AsRoundedTick();
   r.volume= lots.AsRoundedLots();
   CDouble foo = 3.14, bar = 3.139999999999999999999;
   
   Print(foo == bar); //true
   Print(foo <= bar); //true
   Print(foo >  bar); //false
   }
}



