//+------------------------------------------------------------------+
//|                                                        dict3.mq5 |
//|                                                   Enrico Lambino |
//|                             https://www.mql5.com/en/users/iceron |
//+------------------------------------------------------------------+
#property copyright "Enrico Lambino"
#property link      "https://www.mql5.com/en/users/iceron"
#property version   "1.00"
#include <Dictionary.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   test1();
   test2();
  }
//+------------------------------------------------------------------+
//|test1 - dictionary should handle collisions                       |
//|(does not apply to pointers)                                      |
//+------------------------------------------------------------------+
void test1()
  {
   Print("start of "+__FUNCTION__);
   CDictionary *dict=new CDictionary();
   dict.Set<string>("costarring","liquid");
   dict.Set<string>("liquid","costarring");

   Print(dict.Get<string>("costarring"));
   Print(dict.Get<string>("liquid"));

   dict.Delete<string>("costarring");
   Print(dict.Get<string>("liquid"));
   Print(dict.Contains<string>("costarring"));

   delete dict;
   Print("end of "+__FUNCTION__);
  }
//+------------------------------------------------------------------+
//|test2() - reallocation                                            |
//|                                                                  |
//+------------------------------------------------------------------+
void test2()
  {
   Print("start of "+__FUNCTION__);
   uint start_count=GetTickCount();
   CDictionary *dictionary=new CDictionary();
   int max=10000;

   MathSrand((int)GetTickCount());
   for(int i=0;i<max;i++)
     {
      if(!dictionary.Set<int>("value"+(string)i,(i)))
         Print("int not successful");
      if(!dictionary.Set<string>("value"+(string)i,"hello world "+string(i)))
         Print("string not successful");
      if(!dictionary.Set<long>("value"+(string)i,long(i)))
         Print("long not successful");
      if(!dictionary.Set<double>("value"+(string)i,double(i+0.0)))
         Print("double not successful");
      if(!dictionary.Set<datetime>("value"+(string)i,(TimeCurrent())))
         Print("datetime not successful");
      if(!dictionary.Set<CObject*>("value"+(string)i,(new CObject())))
         Print("CObject* not successful");
     }
   
   MathSrand(GetTickCount());
   int value=MathRand();
   int random=value%(max);

   Print("value"+(string)random+"(int): "+(string)dictionary.Get<int>("value"+(string)random));
   Print("value"+(string)random+"(string): "+(string)dictionary.Get<string>("value"+(string)random));
   Print("value"+(string)random+"(long): "+(string)dictionary.Get<long>("value"+(string)random));
   Print("value"+(string)random+"(double): "+(string)dictionary.Get<double>("value"+(string)random));
   Print("value"+(string)random+"(datetime): "+(string)dictionary.Get<datetime>("value"+(string)random));

   delete dictionary;
   uint end_count=GetTickCount();
   Print("execution time: "+(string)(end_count-start_count)+" ms");
   Print("end of "+__FUNCTION__);
  }
//+------------------------------------------------------------------+
