#define __TESTERBENCH__

struct PROFILER
{
  ulong StartTime;
  ulong Interval;
  uint Count;

  PROFILER( void ) : Interval(0), Count(0)
  {
  }

  void Begin( void )
  {
    this.StartTime = ::GetMicrosecondCount();

    return;
  }

  void End( void )
  {
    this.Interval += ::GetMicrosecondCount() - this.StartTime;
    this.Count++;

    return;
  }

  string ToString() const
  {
    return((this.Interval) ? "Count = " + (string)this.Count + ", Interval = " +
                          ::DoubleToString(this.Interval / 1e6, 3) + " s." +
                          ", " + ::DoubleToString(1e6 * this.Count / this.Interval, 1) + " unit/sec" : "");
  }
};

struct TESTER_BENCH
{
private:
  bool FirstRun;
  ulong Interval;

public:
  PROFILER Profiler;

  TESTER_BENCH( void )
  {
    this.Set();
  }

  ~TESTER_BENCH( void )
  {
    if (::MQLInfoInteger(MQL_TESTER) || ::MQLInfoInteger(MQL_OPTIMIZATION) || ::MQLInfoInteger(MQL_FRAME_MODE))
      ::Print(this.ToString());
  }

  void Set( void )
  {
    this.FirstRun = true;
    this.Interval = ::GetMicrosecondCount();

    return;
  }

  double Get( void )
  {
    if (this.FirstRun)
    {
      this.Interval = ::GetMicrosecondCount() - this.Interval;

      this.FirstRun = false;
    }

    return(::NormalizeDouble(this.Interval / 1e6, 3));
  }

  string ToString( void )
  {
    return("Interval = " + ::DoubleToString(this.Get(), 3) +  " s." +
           ((this.Profiler.Interval) ? " (Profiler: " + (string)this.Profiler.ToString() + ")" :
           ", Count = " + (string)this.Profiler.Count +
           ", " + ::DoubleToString(this.Profiler.Count / this.Get(), 1) + " unit/sec"));
  }
};

TESTER_BENCH TesterBench;

#define MACROS_PROFILER(A, B) B.Profiler.Begin(); A; B.Profiler.End();

void OnTick( void )
{
  static bool FirstRun = true;

  if (FirstRun)
  {
    ::TesterBench.Set();

    FirstRun = false;
  }

#ifdef PROFILER_OnTick
  MACROS_PROFILER(::OldOnTick(), ::TesterBench) // https://www.mql5.com/ru/forum/1111/page1961#comment_5493925
#else // PROFILER_OnTick
  ::OldOnTick();

  ::TesterBench.Profiler.Count++;
#endif // PROFILER_OnTick

  return;
}

#undef MACROS_BENCH

#define OnTick OldOnTick

#ifdef __MQL5__

#ifndef REPORT_TESTER

sinput uint Range = 2; //      (>= 2)

double Results[];

template <typename T>
double ArrayMean( const T &Array[] )
{
  T Sum = 0;
  const int Size = ::ArraySize(Array);

  for (int i = 0; i < Size; i++)
    Sum += Array[i];

  return((Size == 0) ? 0 : (double)Sum / Size);
}

#define TOSTRING(A) #A + " = " + (string)(A) + " "

void OnTesterInit( void )
{
  ::Comment("Optimization...");
  ::Print("------\n" + __FUNCTION__);

  ::MathSrand((int)::TimeLocal());

  const int Start = ::MathRand();
  const int Step = ::MathRand();

  const uint TmpRange = (::Range < 2) ? 2 : ::Range;

  ::ParameterSetRange("Range", true, TmpRange, Start, Step, Start + (TmpRange - 1) * Step);
}

void OnTesterDeinit( void )
{
  const int Amount = ::ArraySize(::Results);

  if (Amount)
  {
    const int iMin = ::ArrayMinimum(::Results);
    const int iMax = ::ArrayMaximum(::Results);

    const double dMean = ::ArrayMean(::Results);

    ::Print(TOSTRING(iMin) + "Results[iMin] = " + ::DoubleToString(Results[iMin], 3) + "s.");
    ::Print(TOSTRING(iMax) + "Results[iMax] = " + ::DoubleToString(Results[iMax], 3) + "s.");

    const string Mean = ::DoubleToString(::ArrayMean(::Results), 3);
    ::Print(TOSTRING(Amount) + TOSTRING(Mean) + "s. - " + ::DoubleToString(100 * dMean * Amount / ::TesterBench.Get(), 2) + "%");
  }

  ::Print(__FUNCTION__ + "\n------");

  ::ChartClose();
}

void OnTesterPass( void )
{
  ulong Pass;
  string Name;
  long ID;
  double dOnTester;
  uchar Data[];

  while (::FrameNext(Pass, Name, ID, dOnTester, Data))
  {
    const int i = ::ArrayResize(::Results, ::ArraySize(::Results) + 1) - 1;

    ::Results[i] = dOnTester;
    const string OnTester = DoubleToString(dOnTester, 3); // https://www.mql5.com/ru/forum/1111/page1952#comment_5472947

    ::Print(TOSTRING(i) + TOSTRING(Pass) + TOSTRING(OnTester) + "s.: " + ::CharArrayToString(Data));
  }

  return;
}

#undef TOSTRING

double OnTester( void )
{
  const double Res = ::TesterBench.Get();

  if (::MQLInfoInteger(MQL_OPTIMIZATION))
  {
    uchar Data[];

    ::StringToCharArray(((::TesterBench.Profiler.Interval) ? "OnTick Profiler: " + ::TesterBench.Profiler.ToString() + " " :
                          "Count = " + (string)::TesterBench.Profiler.Count +
                           ", " + ::DoubleToString(::TesterBench.Profiler.Count / ::TesterBench.Get(), 1) + " unit/sec") +
                        ", Agent = " + ::TerminalInfoString(TERMINAL_DATA_PATH) +
                        " build = " + (string)::TerminalInfoInteger(TERMINAL_BUILD), Data);

    ::FrameAdd(NULL, 0, Res, Data);
  }

  return(Res);
}

#define OnTester OldOnTester

#endif // REPORT_TESTER

#else // __MQL5__

input uint Range = 0; //   

double OnTester( void )
{
  return(::TesterBench.Get());
}

#endif // __MQL5__