//+---------------------------------------------------------------------+
//|                                                  ColorParabolic.mq5 | 
//|                         Copyright  2010, Nikolay Kositsin + lukas1 | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin + lukas1"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 4
//----     
#property indicator_plots   4
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----      Magenta 
#property indicator_color1  clrMagenta
//----   1  1
#property indicator_width1  4
//----    
#property indicator_label1  "Lower Parabolic"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----      DodgerBlue 
#property indicator_color2  clrDodgerBlue
//----   2  1
#property indicator_width2  4
//----    
#property indicator_label2 "Upper Parabolic"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----      Magenta 
#property indicator_color3  clrMagenta
//----   3  4
#property indicator_width3  4
//----    
#property indicator_label3  "Parabolic Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----      DodgerBlue 
#property indicator_color4  clrDodgerBlue
//----   4  4
#property indicator_width4  4
//----    
#property indicator_label4 "Parabolic Buy"
//+----------------------------------------------+
//|    Parabolic       |
//+----------------------------------------------+
input double StepH_=0.02;//   
input double MaximumH=0.5;//   
input double StepL_=0.02;//   
input double MaximumL=0.5;//   
//+----------------------------------------------+

//----   ,    
//      
double BuyBuffer[],SellBuffer[];
double UpSarBuffer[],DnSarBuffer[];
//---- 
bool dirlong_,first_;
double ep_,start_,last_high_,last_low_,prev_sar_;
double StepH,StepL;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Parabolic indicator initialization function                      | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=2;
   StepH=MathMin(StepH_,MaximumH);
   StepL=MathMin(StepL_,MaximumL);

//----      
   SetIndexBuffer(0,UpSarBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,158);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(1,DnSarBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,158);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(2,SellBuffer,INDICATOR_DATA);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(3,BuyBuffer,INDICATOR_DATA);
//----       4
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"Parabolic");

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Parabolic iteration function                                     | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[]     //     
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----     
   double price_low,price_high,sar;
   double ep,start,last_high,last_low,prev_sar;
//----        
   int gfirst,bar;
   bool dirlong,first;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      gfirst=begin+min_rates_total; //      
      first_=false;
      dirlong_=false;
      last_high_=0.0;
      last_low_=999999999.0;
      ep_=price[min_rates_total-1];
      prev_sar_=ep_;
      start_=0.0;

      //----      
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,begin+min_rates_total);
      PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,begin+min_rates_total);
      PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,begin+min_rates_total);
      PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,begin+min_rates_total);
     }
   else gfirst=prev_calculated-1; //      

//----   
   ep=ep_;
   start=start_;
   last_high=last_high_;
   last_low=last_low_;
   dirlong=dirlong_;
   first=first_;
   prev_sar=prev_sar_;

//----     Parabolic
   for(bar=gfirst; bar<rates_total; bar++)
     {
      price_low=price[bar];
      price_high=price[bar];
      sar=prev_sar+start*(ep-prev_sar);
      //----
      if(dirlong)
        {
         if(ep<price_high && start+StepL<=MaximumL) start+=StepL;
         if(sar>=price_low)
           {
            start=StepL;
            dirlong=false;
            ep=price_low;
            last_low=price_low;

            if(price_high<last_high) sar=last_high;
            else sar=price_high;
           }
         else
           {
            if(ep<price_low && start+StepL<=MaximumL) start+=StepL;

            if(ep<price_high)
              {
               last_high=price_high;
               ep=price_high;
              }
           }
        }
      //----
      else
        {
         if(ep>price_low && start+StepH<=MaximumH) start+=StepH;
         if(sar<=price_high)
           {
            start=StepH;
            dirlong=true;
            ep=price_high;
            last_high=price_high;
            if(price_low>last_low) sar=last_low;
            else sar=price_low;
           }
         else
           {
            if(ep>price_high && start+StepH<=MaximumH) start+=StepH;

            if(ep>price_low)
              {
               last_low=price_low;
               ep=price_low;
              }
           }
        }

      //----      
      DnSarBuffer[bar]=EMPTY_VALUE;
      UpSarBuffer[bar]=EMPTY_VALUE;

      if(price[bar]<sar) UpSarBuffer[bar]=sar;
      else               DnSarBuffer[bar]=sar;

      //----   
      if(bar==rates_total-2)
        {
         ep_=ep;
         start_=start;
         last_high_=last_high;
         last_low_=last_low;
         dirlong_=dirlong;
         first_=first;
         prev_sar_=sar;
        }
        
        if(bar<rates_total-1) prev_sar=sar;
     }

//----       
   if(prev_calculated>rates_total || prev_calculated<=0)//           
      gfirst++;

//----    Parabolic
   for(bar=gfirst; bar<rates_total; bar++)
     {
      //----      
      BuyBuffer[bar]=EMPTY_VALUE;
      SellBuffer[bar]=EMPTY_VALUE;
      
      if(UpSarBuffer[bar-1]==EMPTY_VALUE&&UpSarBuffer[bar]!=EMPTY_VALUE) SellBuffer[bar]=UpSarBuffer[bar];
      if(DnSarBuffer[bar-1]==EMPTY_VALUE&&DnSarBuffer[bar]!=EMPTY_VALUE) BuyBuffer[bar]=DnSarBuffer[bar];
     }
//----      
   return(rates_total);
  }
//+------------------------------------------------------------------+
