unit UnitServer;

interface

uses
  Windows,
  Dialogs,
  SysUtils,
  DateUtils,
  Classes,
  Forms,
  ComCtrls,
  StdCtrls,
  Controls,
  Winsock, ScktComp;

type
  TFormServer = class(TForm)
    EditPort: TEdit;
    ButtonConnection: TButton;
    Label1: TLabel;
    ButtonClear: TButton;
    ListBoxMsg: TListBox;
    UpDown1: TUpDown;
    Server: TServerSocket;
    procedure ButtonClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonConnectionClick(Sender: TObject);
    procedure ServerClientRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerClientConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerClientDisconnect(Sender: TObject; Socket: TCustomWinSocket);
  private
    { Private declarations }
  public
    function GetLocalIP: String;
  end;

  MqlTick = packed record
    time: Int64;
    bid: Double;
    ask: Double;
    last: Double;
    volume: Int64;
  end;

  SOCKET_DATA = packed record
    symbol: array[0..15] of AnsiChar;
    tick:MqlTick;
  end;


var
  FormServer: TFormServer;

implementation

{$R *.dfm}

//-----------------------------------------------------------------------------+
procedure TFormServer.ButtonClearClick(Sender: TObject);
begin
  ListBoxMsg.Clear;
end;

//-----------------------------------------------------------------------------+
procedure TFormServer.ButtonConnectionClick(Sender: TObject);
begin
  if(Server.Active)then
    begin
      Server.Active:=false;
      ButtonConnection.Caption:='Connect';
      self.Caption:= 'Server';
    end
  else
    begin
      Server.Port:= UpDown1.Position;
      Server.Active:=true;
      self.Caption:= 'Server ' + GetLocalIP + ':' + IntToStr(Server.Port);
      ButtonConnection.Caption:='Disconnect'
  end;
end;

//-----------------------------------------------------------------------------+
procedure TFormServer.FormCreate(Sender: TObject);
begin
  UpDown1.Position:=777;
  ButtonConnectionClick(nil);
end;


//-----------------------------------------------------------------------------+
procedure TFormServer.ServerClientConnect(Sender: TObject;
  Socket: TCustomWinSocket);
var s:String;
begin
  s:= 'Client ' + Inttostr(Socket.SocketHandle) + ' connected';
  ListBoxMsg.Items.Add(S);
end;

//-----------------------------------------------------------------------------+
procedure TFormServer.ServerClientDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
var s:String;
begin
  s:= 'Client ' + Inttostr(Socket.SocketHandle) + ' disconnected';
  ListBoxMsg.Items.Add(S);
end;

//-----------------------------------------------------------------------------+
procedure TFormServer.ServerClientRead(Sender: TObject; Socket: TCustomWinSocket);
var S:string;
    len: Integer;
    data: SOCKET_DATA;
    dt: TDatetime;
begin

  //--- get struct
  if sizeof(SOCKET_DATA) = Socket.ReceiveLength then
  begin
    len:=sizeof(SOCKET_DATA);
    Socket.ReceiveBuf(data,len);

    if(data.tick.time=0)then Exit;

    dt:=IncSecond(UnixDateDelta, data.tick.time);

    S:=Format('Client %d symbol: %s dt: %s bid:%.5f ask:%.5f',[Socket.SocketHandle, data.symbol, datetimetostr(dt), data.tick.bid, data.tick.ask]);
    ListBoxMsg.Items.Add(S);
    ListBoxMsg.TopIndex:= ListBoxMsg.Items.Count-1;
  end
    else // get string
  begin
    S:= Format('Client %d %s',[Socket.SocketHandle,Socket.ReceiveText]);
    ListBoxMsg.Items.Add(S);
    ListBoxMsg.TopIndex:= ListBoxMsg.Items.Count-1;
  end;
end;

//-----------------------------------------------------------------------------+
function TFormServer.GetLocalIP: String;
var
  wsaData: TWSAData;
  P: PHostEnt;
  Buf: array [0..127] of AnsiChar;
begin
  Result := '';
  if WSAStartup($202, wsaData) = 0 then
  begin
    if GetHostName(@Buf, 128) = 0 then
    begin
      P := GetHostByName(@Buf);
      if P <> nil then Result := String(inet_ntoa(PInAddr(p^.h_addr_list^)^));
    end;
    WSACleanup;
  end;
end;

end.
