//+---------------------------------------------------------------------+ 
//|                                                     RVIDiffSign.mq5 | 
//|                                        Copyright  2009, DesO'Regan | 
//|                                              oregan_des@hotmail.com | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2009, DesO'Regan"
#property link "oregan_des@hotmail.com"
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2
//----    
#property indicator_plots  2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "RVIDiffSign Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "RVIDiffSign Buy"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint RVIPeriod=12;
input Smooth_Method XMA_Method=MODE_T3;        //  
input uint XLength=13;                         //                     
input int XPhase=15;                           // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
//+----------------------------------------------+
//----      
int  min_rates_1,min_rates_total;
//---   ,         
double SellBuffer[],BuyBuffer[];
//----      
int RVI_Handle,ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    iATR
   int ATR_Period=15;
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      iATR");
      return(INIT_FAILED);
     }
//----    iRVI
   RVI_Handle=iRVI(NULL,0,RVIPeriod);
   if(RVI_Handle==INVALID_HANDLE)
     {
      Print("      iRVI");
      return(INIT_FAILED);
     }
//----     
   min_rates_1=int(RVIPeriod)+1+3+1;
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_total=int(MathMax(ATR_Period,min_rates_total))+1;

//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----    1,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,176);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,176);
//---       
   ArraySetAsSeries(BuyBuffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"RVIDiffSign("+string(RVIPeriod)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[]
                )
  {
//----       
   if(BarsCalculated(RVI_Handle)<rates_total || BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----   
   int to_copy,limit,bar,maxbar;
   double RVI[],Sign[],ATR[],diff,xdiff;
   static double xdiff1,xdiff2;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_1-1; //      
     }
   else limit=rates_total-prev_calculated; //      

   to_copy=limit+1;
   maxbar=rates_total-1-min_rates_1;

//----      
   if(CopyBuffer(RVI_Handle,MAIN_LINE,0,to_copy,RVI)<=0) return(RESET);
   if(CopyBuffer(RVI_Handle,SIGNAL_LINE,0,to_copy,Sign)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,MAIN_LINE,0,to_copy,ATR)<=0) return(RESET);
   
//----         
   ArraySetAsSeries(RVI,true);
   ArraySetAsSeries(Sign,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      diff=RVI[bar]-Sign[bar];
      xdiff=XMA1.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,diff,bar,true);
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(xdiff2>xdiff1 &&  xdiff1<xdiff) BuyBuffer[bar]=Low[bar]-ATR[bar]*3/8;
      if(xdiff2<xdiff1 &&  xdiff1>xdiff) SellBuffer[bar]=High[bar]+ATR[bar]*3/8;
      //---
      if(bar)
        {
          xdiff2=xdiff1;
          xdiff1=xdiff;
        }
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+