//+------------------------------------------------------------------+
//|                                             FloatPivot_Digit.mq5 |
//|                                 Copyright  2006, Nick A. Zhilin |
//|                                              rebus@dialup.etr.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick A. Zhilin"
#property link      "rebus@dialup.etr.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//---        
#property indicator_buffers 7
//---    
#property indicator_plots   5
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----      PaleGreen
#property indicator_color1  clrPaleGreen
//----   
#property indicator_label1  "Upper Cloud"
//+----------------------------------------------+
//|              |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        LimeGreen
#property indicator_color2  clrLimeGreen
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Upper FloatPivot"
//+----------------------------------------------+
//|                |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        SlateBlue
#property indicator_color3  clrSlateBlue
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Middle FloatPivot"
//+----------------------------------------------+
//|               |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_LINE
//----        Magenta
#property indicator_color4  clrMagenta
//----   4 -  
#property indicator_style4  STYLE_SOLID
//----    4  2
#property indicator_width4  2
//----    
#property indicator_label4  "Lower FloatPivot"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----      Violet
#property indicator_color5  clrViolet
//----   
#property indicator_label5  "Lower Cloud"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="FloatPivot_Digit";           //    
input int IPeriod=100;                              //  
input int Shift=0;                                  //     
input uint Digit=2;                                 //  
input bool ShowPrice=true;                          //  
input color Upper_color=clrTeal;                    //   
input color Middle_color=clrBlue;                   //   
input color Lower_color=clrMagenta;                 //   
//+----------------------------------------------+
//----   ,         
double ExtUp1Buffer[];
double ExtUp2Buffer[];
double ExtABuffer[];
double ExtBBuffer[];
double ExtCBuffer[];
double ExtDn1Buffer[];
double ExtDn2Buffer[];
//----      
int  min_rates_total;
//----     
string upper_name,middle_name,lower_name;
double PointPow10;
//+------------------------------------------------------------------+
//|  searching index of the highest bar                              |
//+------------------------------------------------------------------+
int iHighest(
             const double &array[],//      
             int count,//    (        ), 
             //      .
             int startPos // (   )  , 
             //      
             )
  {
//----+
   int index=startPos;

//----     
   if(startPos<0)
     {
      Print("    iHighest, startPos = ",startPos);
      return(0);
     }

//----   startPos  
   if(startPos-count<0)
      count=startPos;

   double max=array[startPos];

//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]>max)
        {
         index=i;
         max=array[i];
        }
     }
//----+    
   return(index);
  }
//+------------------------------------------------------------------+
//|  searching index of the lowest bar                               |
//+------------------------------------------------------------------+
int iLowest(
            const double &array[],//      
            int count,//    (        ), 
            //      .
            int startPos // (   )  , 
            //      
            )
  {
//----+
   int index=startPos;

//----     
   if(startPos<0)
     {
      Print("    iLowest, startPos = ",startPos);
      return(0);
     }

//----   startPos  
   if(startPos-count<0)
      count=startPos;

   double min=array[startPos];

//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]<min)
        {
         index=i;
         min=array[i];
        }
     }
//----+    
   return(index);
  }
//+------------------------------------------------------------------+    
//| FloatPivot Channel indicator initialization function             | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(MathMax(3,IPeriod));
//----  
   upper_name=SirName+" upper text lable";
   middle_name=SirName+" middle text lable";
   lower_name=SirName+" lower text lable";
//----           
   PointPow10=_Point*MathPow(10,Digit);
//----      
   SetIndexBuffer(0,ExtUp1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtUp2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(2,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(3,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(4,ExtCBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(5,ExtDn1Buffer,INDICATOR_DATA);
   SetIndexBuffer(6,ExtDn2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);

//----      
   string shortname;
   StringConcatenate(shortname,"FloatPivot_Digit( IPeriod = ",IPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,upper_name);
   ObjectDelete(0,middle_name);
   ObjectDelete(0,lower_name);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+  
//| FloatPivot Channel iteration function                            | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----   
   int first,bar;

//----    first    
   if(prev_calculated==0) //      
     {
      first=min_rates_total-1; //      
     }
   else
     {
      first=prev_calculated-1;//      
     }

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double max=high[iHighest(high,IPeriod,bar)];
      double min=low[iLowest(low,IPeriod,bar)];
      double pivot=(close[bar-1]+close[bar-2]+close[bar-3])/3;
      // Pivot
      double res=(max+min+pivot)/3;
      // (R1 - Pivot) / 2
      ExtABuffer[bar]=ExtUp1Buffer[bar]=PointPow10*MathCeil(((2*res-min)+res)/2/PointPow10);
      ExtCBuffer[bar]=ExtDn2Buffer[bar]=PointPow10*MathFloor((res+(2*res-max))/2/PointPow10);      
      ExtBBuffer[bar]=ExtUp2Buffer[bar]=ExtDn1Buffer[bar]=PointPow10*MathRound(res/PointPow10);
     }
//----
   if(ShowPrice)
     {
      int bar0=rates_total-Shift-1;
      datetime time0=time[bar0];
      SetRightPrice(0,upper_name,0,time0,ExtABuffer[bar0],Upper_color);
      SetRightPrice(0,middle_name,0,time0,ExtBBuffer[bar0],Upper_color);
      SetRightPrice(0,lower_name,0,time0,ExtCBuffer[bar0],Lower_color);
     }
//----
   ChartRedraw(0);   
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
