//+------------------------------------------------------------------+ 
//|                                                      yEffekt.mq5 | 
//|                                         Copyright  2008, MNS777 | 
//|                                                mns777.ru@mail.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2008, MNS777"
#property link "mns777.ru@mail.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 Gray,Teal,DarkViolet,IndianRed,Magenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "yEffekt"

//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +0.5
#property indicator_level2  0.0
#property indicator_level3 -0.5
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT

//----      
int min_rates_total;
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+    
//| yEfekt indicator initialization function                         | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=5;

//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);

//----      
   string shortname="yEffekt";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//----  
  }
//+------------------------------------------------------------------+  
//| yEfekt iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----   
   int limit1,limit2,bar;
//----       
   double Index;

//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit1=rates_total-1-min_rates_total; //        
      limit2=limit1-1; //        
     }
   else //      
     {
      limit1=rates_total-prev_calculated;
      limit2=limit1;
     }

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----    
   for(bar=limit1; bar>=0; bar--)
     {
      Index=(high[bar]-low[bar])+(high[bar+1]-low[bar+1])+(high[bar+2]-low[bar+2])+(high[bar+3]-low[bar+3])+(high[bar+4]-low[bar+4]);

      if(Index!=0.0)
        {
         if(high[bar] > low[bar+4] ) IndBuffer[bar]=(high[bar]-low[bar+4])/Index;
         if(low[bar]  < high[bar+4]) IndBuffer[bar]=(low[bar] - high[bar+4] )/Index;
        }
      else IndBuffer[bar]=0.0;

     }

//----     Ind
   for(bar=limit2; bar>=0; bar--)
     {
      ColorIndBuffer[bar]=0;

      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar+1]) ColorIndBuffer[bar]=1;
         if(IndBuffer[bar]<IndBuffer[bar+1]) ColorIndBuffer[bar]=2;
        }

      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar+1]) ColorIndBuffer[bar]=3;
         if(IndBuffer[bar]>IndBuffer[bar+1]) ColorIndBuffer[bar]=4;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
