//+------------------------------------------------------------------+
//|                                                      IncMIDI.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"


#import "winmm.dll"
    long midiOutClose(int hMidiOut);
    int midiOutOpen(int & lphMidiOut,int uDeviceID,int dwCallback,int dwInstance,int dwFlags);
    int midiOutReset(int hMidiOut);
    int midiOutShortMsg(int hMidiOut,int dwMsg);
    int midiOutSetVolume(int uDeviceID,int dwVolume);
#import

class CMIDI{
   private:
      int m_VolL;   
      int m_VolR;
      int m_VolB;
      int m_i;
      int m_DeviceID;
      int m_hMIDI;
      ushort m_EventID;
      int m_ChartEventID;
      long m_TickMS;
      long m_NextTime;
      bool m_Stop;
      string m_Mus[];
      int m_Len;
      string m_tmp[];
      string m_tmp2[];
      int m_ts;
      void Command(string aCommand){
         StringSplit(aCommand,',',m_tmp);
         m_ts=ArraySize(m_tmp);
            for(int i=0;i<m_ts;i++){
               long m_val;
               string m_com=m_tmp[i];
               StringTrimLeft(m_com);
               StringTrimRight(m_com);
               StringToLower(m_com);
               StringSplit(m_com,'=',m_tmp2);
                  if(ArraySize(m_tmp2)==2){
                     m_com=m_tmp2[0];
                     StringTrimRight(m_com);
                     m_val=StringToInteger(m_tmp2[1]);
                        if(m_com=="tick"){
                           m_TickMS=m_val;
                        }
                        else if(m_com=="volume"){
                           m_VolL=int(0xFFFF*m_val/100);
                           m_VolR=int(0xFFFF*m_val/100);
                           m_VolB=(m_VolL<<16)|m_VolR;
                           midiOutSetVolume(m_DeviceID,m_VolB); 
                        }
                        else if(m_com=="volumel"){
                           m_VolL=int(0xFFFF*m_val/100);
                           m_VolB=(m_VolL<<16)|m_VolR;
                           midiOutSetVolume(m_DeviceID,m_VolB); 
                        }  
                        else if(m_com=="volumer"){
                           m_VolR=int(0xFFFF*m_val/100);
                           m_VolB=(m_VolL<<16)|m_VolR;
                           midiOutSetVolume(m_DeviceID,m_VolB); 
                        }  
                        else if(m_com=="instrument"){
                           midiOutShortMsg(m_hMIDI,(int)(192+m_val*256));   
                        }    
                        else if(m_com=="notedn"){
                           midiOutShortMsg(m_hMIDI,(int)(5898384+m_val*256));
                        }
                        else if(m_com=="noteup"){
                           midiOutShortMsg(m_hMIDI,(int)(144+m_val*256));
                        }                                    
                  }
                  else if(ArraySize(m_tmp2)==1){
                     if(m_tmp2[0]=="stop"){
                        Stop();
                     }
                  }
                  
            }      
      }
   public:
      void SetEventID(ushort aID){
         m_EventID=aID;
      }
      void SetMusic(string & aMusic[]){
         m_Len=ArraySize(aMusic);
         ArrayResize(m_Mus,m_Len);
         ArrayCopy(m_Mus,aMusic);
      }
      void Play(bool aSynch=true){
         Stop();
         m_DeviceID=0;
         m_VolL=0xFFFF;
         m_VolR=0xFFFF;
         m_VolB=(m_VolL<<16)|m_VolR;
         m_i=0;
            if(midiOutOpen(m_hMIDI, m_DeviceID, 0, 0, 0)!=0){
               Alert("Error midiOutOpen");
               return;
            } 
         midiOutSetVolume(m_DeviceID,m_VolB);  
         if(m_EventID==0)m_EventID=1;              
         m_ChartEventID=CHARTEVENT_CUSTOM+m_EventID;
         m_TickMS=0;
         m_NextTime=0;  
         m_Stop=false; 
            if(aSynch){
               for(int i=0;i<m_Len;i++){
                  Command(m_Mus[i]);
                  Sleep((int)m_TickMS);
               }
            }
            else{
               EventChartCustom(ChartID(),m_EventID,0,0,NULL);   
            }               
      }   
      void Stop(){
         m_Stop=true;
         midiOutClose(m_hMIDI);
      }
      void ChartEvent(const int id,const long &lparam,const double &dparam,const string &sparam){
         if(m_Stop){
            return;
         }
         if(id==m_ChartEventID){
            long tk=GetTickCount();
               if(tk>=m_NextTime){
                  if(m_i<m_Len){
                     Command(m_Mus[m_i]);
                     m_NextTime=tk+m_TickMS;
                     m_i++;
                  }  
               } 
            EventChartCustom(ChartID(),m_EventID,0,0,NULL);      
         }
      }
      
};