//+---------------------------------------------------------------------+
//|                                          AverageOfATR_Histogram.mq5 |
//|                                        Copyright 2015, FXMatics.com |
//|                                             http://www.fxmatics.com |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright 2015, FXMatics.com"
#property link      "http://www.fxmatics.com"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 4 
//----     
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1  clrYellow,clrDarkBlue
//----   - 
#property indicator_style1 STYLE_SOLID
//----     3
#property indicator_width1 3
//----   
#property indicator_label1  "AverageOfATR_Histogram"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---       
#property indicator_color2  clrMagenta
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2  "AverageOfATR Trend"
//+----------------------------------------------+
//|             |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---       
#property indicator_color3  clrDodgerBlue
//---    3  2
#property indicator_width3  2
//---    
#property indicator_label3 "AverageOfATR Flat"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0                    //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int    ATRPeriod=7;
input Smooth_Method XMA_Method=MODE_SMA; // 
input int XLength=3; //  
input int XPhase=15; // 
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//      
double IndBuffer[],ColorBuffer[];
double UpIndBuffer[],DnIndBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_ATR,min_rates_total;
//+------------------------------------------------------------------+   
//| ATR Channels indicator initialization function                   | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----     
   min_rates_ATR=int(ATRPeriod);
   min_rates_total=min_rates_ATR+GetStartBars(XMA_Method,XLength,XPhase)+2;
//----       
   XMA.XMALengthCheck("XLength",XLength);
   XMA.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorBuffer,true);

//---      
   SetIndexBuffer(2,UpIndBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//---       
   ArraySetAsSeries(UpIndBuffer,true);

//---      
   SetIndexBuffer(3,DnIndBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(2,PLOT_ARROW,163);
//---       
   ArraySetAsSeries(DnIndBuffer,true);

//----      
   string shortname;
   string Smooth=XMA.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"AverageOfATR_Histogram(",ATRPeriod," ",XLength," ",Smooth,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,4);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| ATR Channels iteration function                                  | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----   
   int to_copy,limit,bar,maxbar,clr;
   double ATR[],diff,xatr;
   static double diff_prev;
   maxbar=rates_total-1-min_rates_ATR-2;
//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
      diff_prev=0.0;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+2;
//----       
   ArraySetAsSeries(ATR,true);
//----       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      xatr=XMA.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,ATR[bar],bar,true);
      diff=IndBuffer[bar]=ATR[bar]-xatr;
      if(diff>0) clr=0;
      else clr=1;
      ColorBuffer[bar]=clr;
      //----      
      UpIndBuffer[bar]=EMPTY_VALUE;
      DnIndBuffer[bar]=EMPTY_VALUE;
      if(diff>0 && diff_prev<=0) UpIndBuffer[bar]=0.0;
      if(diff<0 && diff_prev>=0) DnIndBuffer[bar]=0.0;
      //----
      if(bar) diff_prev=diff;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
