//+------------------------------------------------------------------+
//|                                                 ColorStochNR.mq5 | 
//|                                      Copyright  2010, Svinozavr |
//|                                                                  |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2010, Svinozavr"
//----  
#property link      ""
#property description "    ,     "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 5 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM2
//----     
#property indicator_color1 clrGray,clrLightSeaGreen,clrDodgerBlue,clrDeepPink,clrMagenta
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "Main"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----      
#property indicator_type2   DRAW_COLOR_LINE
//----      
#property indicator_color2 clrGray,clrLime,clrMagenta
//----   - 
#property indicator_style2  STYLE_DASH
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "Signal"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  70.0
#property indicator_level2  50.0
#property indicator_level3  30.0
#property indicator_levelcolor Violet
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_MA_METHOD_
  {
   MODE_SMA_,       //  
   MODE_EMA_        // 
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Kperiod=5;  // K period
input uint Dperiod=3;  // D period
input uint Slowing=3;  // Slowing
input ENUM_MA_METHOD_ Dmethod=MODE_SMA_; //  
input ENUM_STO_PRICE PriceFild=STO_LOWHIGH; //   
input uint Sens=0; //   
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double UpSTOH[],DnSTOH[],SIGN[];
double ColorSTOH[],ColorSIGN[];
//----      
int min_rates_total;
//----
double sens; //   
double kd; // . EMA  
//+------------------------------------------------------------------+   
//| STOH indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(Kperiod+Dperiod+Slowing+1);
//----    
   sens=Sens*_Point; //   
   if(Dmethod==MODE_EMA_) kd=2.0/(1+Dperiod); // . EMA  
//----      
   SetIndexBuffer(0,UpSTOH,INDICATOR_DATA);
//----       
   ArraySetAsSeries(UpSTOH,true);
//----      
   SetIndexBuffer(1,DnSTOH,INDICATOR_DATA);
//----       
   ArraySetAsSeries(DnSTOH,true);
//----     ,     
   SetIndexBuffer(2,ColorSTOH,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorSTOH,true);
//----      
   SetIndexBuffer(3,SIGN,INDICATOR_DATA);
//----       
   ArraySetAsSeries(SIGN,true);
//----     ,     
   SetIndexBuffer(4,ColorSIGN,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorSIGN,true);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"StochNR("+(string)Kperiod+","+(string)Dperiod+","+(string)Slowing+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| STOH iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----   
   int limit,bar;
//----       
   double Main,prevMain;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      SIGN[limit+1]=50;
      for(bar=rates_total-1; bar>limit && !IsStopped(); bar--)
        {
         UpSTOH[bar]=50;
         DnSTOH[bar]=50;
        }
     }
   else limit=rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----  
      Main=Stoch(Kperiod,Slowing,PriceFild,sens,high,low,close,bar);
      //----
      if(Main<50)
        {
         DnSTOH[bar]=Main;
         UpSTOH[bar]=50;
        }
      else
        {
         UpSTOH[bar]=Main;
         DnSTOH[bar]=50;
        }
      //----  
      switch(Dmethod)
        {
         case MODE_EMA_: /* EMA */  SIGN[bar]=kd*Main+(1-kd)*SIGN[bar+1]; break;
         case MODE_SMA_: /* SMA */
           {
            int sh=int(bar+Dperiod);
            double OldMain=UpSTOH[sh]+DnSTOH[sh]-50;
            double sum=SIGN[bar+1]*Dperiod-OldMain;
            SIGN[bar]=(sum+Main)/Dperiod;
           }
        }
     }
//----
   if(!prev_calculated) limit--;
//----     Stoh
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorSTOH[bar]=0;
      Main=UpSTOH[bar]+DnSTOH[bar]-50;
      prevMain=UpSTOH[bar+1]+DnSTOH[bar+1]-50;
      //----
      if(Main>50)
        {
         if(Main>prevMain) ColorSTOH[bar]=1;
         if(Main<prevMain) ColorSTOH[bar]=2;
        }
      //----
      if(Main<50)
        {
         if(Main<prevMain) ColorSTOH[bar]=3;
         if(Main>prevMain) ColorSTOH[bar]=4;
        }
     }
//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorSIGN[bar]=0;
      Main=UpSTOH[bar]+DnSTOH[bar]-50;
      //----
      if(Main>SIGN[bar]) ColorSIGN[bar]=1;
      if(Main<SIGN[bar]) ColorSIGN[bar]=2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+ 
//| STOH iteration function                                          | 
//+------------------------------------------------------------------+ 
double Stoch(int Kperiod_, // %K
             int Slowing_, // 
             ENUM_STO_PRICE PriceFild_,//  
             double Sens_,//   
             const double &High[],
             const double &Low[],
             const double &Close[],
             int index) // 
  {
//----
   double delta,sens2,s0;
//----   
   double max=0.0;
   double min=0.0;
   double closesum=0.0;
//----
   for(int j=index; j<index+Slowing_; j++)
     {
      if(PriceFild_==STO_CLOSECLOSE) //  Close
        {
         max+=Close[ArrayMaximum(Close,j,Kperiod_)];
         min+=Close[ArrayMinimum(Close,j,Kperiod_)];
        }
      else //  High/Low
        {
         max+=High[ArrayMaximum(High,j,Kperiod_)];
         min+=Low[ArrayMinimum(Low,j,Kperiod_)];
        }
      //----
      closesum+=Close[j];
     }
//----
   delta=max-min;
//----
   if(delta<Sens_)
     {
      sens2=Sens_/2;
      max+=sens2;
      min-=sens2;
     }
//----
   delta=max-min;
//----
   if(delta) s0=(closesum-min)/delta;
   else s0=1.0;
//----
   return(100*s0);
  }
//+------------------------------------------------------------------+
