//+---------------------------------------------------------------------+
//|                                                       Squize_MA.mq5 | 
//| mtf:ForexTSD.com                          Copyright  2007, Kalenzo | 
//| mladen's formula   ki                   bartlomiej.gorski@gmail.com |
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2007, Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"
#property description "     MA -      ." 
#property description "         ."
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    4
#property indicator_buffers 4 
//----   4  
#property indicator_plots   4
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       Chocolate 
#property indicator_color1 clrChocolate
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Squize_MA1"
//+--------------------------------------------+
//|         |
//+--------------------------------------------+
//----      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----    
#property indicator_color2  clrTeal
#property indicator_color3  clrRed
//----   -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//----    5
#property indicator_width2  5
#property indicator_width3  5
//----    
#property indicator_label2  "+Squize_MA Env"
#property indicator_label3  "-Squize_MA Env"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type4   DRAW_LINE
//----       - 
#property indicator_color4 clrBlueViolet
//----   -  
#property indicator_style4  STYLE_SOLID
//----     2
#property indicator_width4  2
//----   
#property indicator_label4  "Squize_MA2"
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_EMA; //   
input uint Length1=5; //    
input int Phase1=15;  //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Applied_price_ IPC1=PRICE_CLOSE; //  
input Smooth_Method MA_Method2=MODE_EMA; //   
input uint Length2=21; //    
input int Phase2=100;  //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Applied_price_ IPC2=PRICE_CLOSE; //  
input uint MAsThreSHoldPips=15;
input bool ATRmode=true;
input uint ATRperiod=50;
input double ATRmultipl=0.4;
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double XMA1Buffer[],XMA2Buffer[];
//----   ,    
//----        
double ExtLineBuffer1[],ExtLineBuffer2[];
//----      
int ATR_Handle;
//----      
uint min_rates_1,min_rates_2,min_rates_total;
//+------------------------------------------------------------------+   
//| Squize_MA indicator initialization function                      | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=MathMax(min_rates_1,min_rates_2);
   if(ATRmode) min_rates_total+=ATRperiod;
//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
   XMA2.XMALengthCheck("BandsPeriod",ATRperiod);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);
//----    ATR
   if(ATRmode)
     {
      ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRperiod);
      if(ATR_Handle==INVALID_HANDLE) Print("      ATR");
     }
//----      
   SetIndexBuffer(0,XMA1Buffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----          
   ArraySetAsSeries(XMA1Buffer,true);

//----      
   SetIndexBuffer(1,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer2,INDICATOR_DATA);
//----  ,      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----          
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);

//----      
   SetIndexBuffer(3,XMA2Buffer,INDICATOR_DATA);
//----    4  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----          
   ArraySetAsSeries(XMA2Buffer,true);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"X2MA_Bollinger Bands(",
                     Length1,", ",Length2,", ",ATRperiod,", ",Smooth1,", ",Smooth2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Squize_MASquize_MA iteration function                            | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if((ATRmode && BarsCalculated(ATR_Handle)<rates_total) || rates_total<int(min_rates_total)) return(RESET);
//----       
   double price_1,price_2,x1xma,x2xma,madif,delta,Range[];
//----        
   int to_copy,limit,bar;
   uint maxbar=rates_total-1;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total; //    
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
      to_copy=limit+1; //     
     }
//----       Range[]
   if(ATRmode)if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);
//----         
   ArraySetAsSeries(Range,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----   PriceSeries     price_
      price_1=PriceSeries(IPC1,bar,open,low,high,close);
      price_2=PriceSeries(IPC2,bar,open,low,high,close);
      //----    XMASeries
      //----     begin   StartBars1, . .   XMA 
      x1xma = XMA1.XMASeries(maxbar, prev_calculated, rates_total, MA_Method1, Phase1, Length1, price_1, bar, true);
      x2xma = XMA2.XMASeries(maxbar, prev_calculated, rates_total, MA_Method2, Phase2, Length2, price_2, bar, true);
      madif = MathAbs(x1xma-x2xma);
      //----
      XMA1Buffer[bar]=x1xma;
      XMA2Buffer[bar]=x2xma;
      //----
      if(ATRmode) delta=Range[bar]*ATRmultipl/_Point;
      else        delta=MAsThreSHoldPips;
      //----
      if(madif/_Point<delta)
        {
         double dPoint=delta*_Point;
         ExtLineBuffer1[bar]=x2xma+dPoint;
         ExtLineBuffer2[bar]=x2xma-dPoint;
        }
      else
        {
         ExtLineBuffer1[bar]=EMPTY_VALUE;
         ExtLineBuffer2[bar]=EMPTY_VALUE;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
