//+------------------------------------------------------------------+
//|                                                  BigBarSound.mq5 |
//|                                               Alexey Volchanskiy |
//|                                         http://www.robo-forex.ru |
//+------------------------------------------------------------------+
#property copyright "Alexey Volchanskiy"
#property link      "http://www.robo-forex.ru"
#property version   "1.00"
#property strict
#property description "Indicator plays WavFile when bar size is lager of BarPoint value"
//----     
#property indicator_chart_window
//----    0
#property indicator_buffers 0
//----    
#property indicator_plots   0
//+------------------------------------------------+
//|                              |
//+------------------------------------------------+
#define RESET 0                            //        
#define INDICATOR_NAME "BigBarSound"       //    
//+------------------------------------------------+ 
//|            |
//+------------------------------------------------+ 
enum START_POINT // 
  {
   OPEN_CLOSE,   //    open  close
   HIGH_LOW      //   low  high
  };
//+------------------------------------------------+
//|                      |
//+------------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame   = PERIOD_H4;      //   
input uint            BarPoint    = 200;            //      
input START_POINT     SP          = HIGH_LOW;       //  
input string          WavFile     = "alert.wav";    //   
input uint            TimeDeley   = 10;             //     
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",EnumToString(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(Bars(Symbol(),TimeFrame)<1) return(RESET);
//---         
   ArraySetAsSeries(time,true);
   int range;
   static datetime lasttime,itime;
   datetime iTime[1];
//---      
   if(SP==HIGH_LOW)
     {
      double iLow[1],iHigh[1];
      if(CopyLow(Symbol(),TimeFrame,time[0],1,iLow)<=0) return(RESET);
      if(CopyHigh(Symbol(),TimeFrame,time[0],1,iHigh)<=0) return(RESET);
      range=int((iHigh[0]-iLow[0])/_Point);
     }
   else
     {
      double iOpen[1],iClose[1];
      if(CopyOpen(Symbol(),TimeFrame,time[0],1,iOpen)<=0) return(RESET);
      if(CopyClose(Symbol(),TimeFrame,time[0],1,iClose)<=0) return(RESET);
      range=int((MathAbs(iClose[0]-iOpen[0]))/_Point);
     }
   if(CopyTime(Symbol(),TimeFrame,time[0],1,iTime)<=0) return(RESET);
   if(iTime[0]!=itime)
     {
      lasttime=NULL;
      itime=iTime[0];
     }
//---
   if(TimeCurrent()-lasttime>=TimeDeley && range>int(BarPoint))
     {
      PlaySound(WavFile);
      lasttime=TimeCurrent();
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
