//+------------------------------------------------------------------+
//|                                               Exp_MACDCandle.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+---------------------------------------------------+
//|                             |
//+---------------------------------------------------+
enum MODE
  {
   MODE_HISTOGRAM=0,    // 
   MODE_SIGNAL_LINE=1   //  
  };
//+---------------------------------------------------+
//|                                  |
//+---------------------------------------------------+
#include <TradeAlgorithms.mqh>
//+---------------------------------------------------+
//|                           |
//+---------------------------------------------------+
input double MM=0.1;              //       
input MarginMode MMMode=LOT;      //    
input int    StopLoss_=1000;      //   
input int    TakeProfit_=2000;    //   
input int    Deviation_=10;       // .    
input bool   BuyPosOpen=true;     //      
input bool   SellPosOpen=true;    //      
input bool   BuyPosClose=true;    //      
input bool   SellPosClose=true;   //      
//+--------------------------------------------------+
//|     MACDCandle      |
//+--------------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H4; //  
input uint SignalBar=1;                           //      
input uint  fast_ema_period=12;             //   
input uint  slow_ema_period=26;             //   
input uint  signal_period=9;                //   
input MODE  mode=MODE_SIGNAL_LINE;          //    
//+--------------------------------------------------+
//----          
int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    MACDCandle
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"MACDCandle",fast_ema_period,slow_ema_period,signal_period,mode);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("     MACDCandle");
      return(INIT_FAILED);
     }
//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);
//----     
   min_rates_total=int(MathMax(fast_ema_period,slow_ema_period));
   if(mode==MODE_SIGNAL_LINE) min_rates_total+=int(signal_period);
   min_rates_total+=int(1+2+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;
//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);
//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;
      //----   
      double Col[2];
      //----      
      if(CopyBuffer(InpInd_Handle,4,SignalBar,2,Col)<=0) {Recount=true; return;}
      //----    
      if(Col[1]==2)
        {
         if(BuyPosOpen && Col[0]<2) BUY_Open=true;  
         if(SellPosClose) SELL_Close=true;      
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
      //----    
      if(Col[1]==0)
        {
         if(SellPosOpen && Col[0]>0) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;     
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
     }
//+----------------------------------------------+
//|                              |
//+----------------------------------------------+
//----   
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);
//----   
   SellPositionClose(SELL_Close,Symbol(),Deviation_);
//----   
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----   
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
  }
//+------------------------------------------------------------------+
