//+------------------------------------------------------------------+
//|                                               LeManTrendSign.mq5 |
//|                                         Copyright  2009, LeMan. | 
//|                                                 b-market@mail.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2009, LeMan."
//----    
#property link "b-market@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                        //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrRed
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "LeManTrend Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrGreen
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2 "LeManTrend Buy"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Min       = 13;
input int Midle     = 21;
input int Max       = 34;
input int PeriodEMA = 3; //  
input int Shift=0;       //      
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[],BuyBuffer[];
//---      
int ATR_Handle;
//----      
int min_rates_total,start;
//+------------------------------------------------------------------+
//|   CMoving_Average                                  |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---    ATR
   int ATR_Period=15;
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----     
   start=MathMax(MathMax(Min,Midle),Max);
   min_rates_total=start+PeriodEMA+1;
   min_rates_total=MathMax(min_rates_total,ATR_Period);
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----       
   ArraySetAsSeries(SellBuffer,true);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,234);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,233);
//----       
   ArraySetAsSeries(BuyBuffer,true);

//----      
   string shortname;
   StringConcatenate(shortname,"LeManTrendSign(",Min,", ",Midle,", ",Max,", ",PeriodEMA,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy,bar,maxbar;
   double High1,High2,High3,Low1,Low2,Low3,HH,LL,ATR[],Bulls,Bears,trend;
   static double trend_prev;
//----    maxbar   MASeries()
   maxbar=rates_total-1-start;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
      trend_prev=0;
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
//----    CMoving_Average   SmoothAlgorithms.mqh
   static CMoving_Average BULLS,BEARS;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      High1=high[ArrayMaximum(high,bar+1,Min)];
      High2=high[ArrayMaximum(high,bar+1,Midle)];
      High3=high[ArrayMaximum(high,bar+1,Max)];
      HH=((high[bar]-High1)+(high[bar]-High2)+(high[bar]-High3));
      //----
      Low1=low[ArrayMinimum(low,bar+1,Min)];
      Low2=low[ArrayMinimum(low,bar+1,Midle)];
      Low3=low[ArrayMinimum(low,bar+1,Max)];
      LL=((Low1-low[bar])+(Low2-low[bar])+(Low3-low[bar]));
      //----
      Bulls=BULLS.MASeries(maxbar,prev_calculated,rates_total,PeriodEMA,MODE_EMA,HH,bar,true);
      Bears=BEARS.MASeries(maxbar,prev_calculated,rates_total,PeriodEMA,MODE_EMA,LL,bar,true);
      trend=Bulls-Bears;
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      if(trend_prev<=0 && trend>0) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(trend_prev>=0 && trend<0) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      if(bar) trend_prev=trend;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
