//+---------------------------------------------------------------------+
//|                                                             EMV.mq5 |
//|                                  Copyright  2011, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): terminal_data_folder\MQL5\Include             |
//+---------------------------------------------------------------------+
//----  
#property copyright "Copyright  2011, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru"
#property description "Ease of Movement Value"
//----   
#property version   "1.10"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 1
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----       - 
#property indicator_color1  clrMediumSlateBlue
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Ease of Movement Value"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      //  
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE_,        // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price 
  };
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method MA_SMethod=MODE_SMA;           //  
input int SmLength=14;                             //                      
input int SmPhase=15;                              //  
input Applied_price_ IPC=PRICE_QUARTER_;           //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input int Shift=0;                                 //       
//+----------------------------------------------+
//----   ,    
//----      
double EMVBuffer[];
//----      
int StartBars;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   StartBars=XMA1.GetStartBars(MA_SMethod,SmLength,SmPhase)+1;
//----       
   XMA1.XMALengthCheck("Length", SmLength);
   XMA1.XMAPhaseCheck("Phase", SmPhase, MA_SMethod);
//----    
//----    EMVBuffer[]   
   SetIndexBuffer(0,EMVBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  StartBars
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBars);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"Ease of Movement Value");
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<StartBars) return(0);
//----    
   int first,bar;
   double price0,price1,EMV;
   long Volume;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1;                                           //      
     }
//----
   else first=prev_calculated-1;                         //      
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   PriceSeries     price_
      price0=PriceSeries(IPC,bar,  open,low,high,close);
      price1=PriceSeries(IPC,bar-1,open,low,high,close);
      //----
      if(VolumeType==VOLUME_TICK) Volume=long(tick_volume[bar]);
      else                        Volume=long(volume[bar]);
      //----
      if(Volume!=0) EMV=(price0-price1)*price0/(2*Volume);
      else          EMV=0;
      //----
      EMVBuffer[bar]=XMA1.XMASeries(1,prev_calculated,rates_total,MA_SMethod,SmPhase,SmLength,EMV,bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
