//+------------------------------------------------------------------+
//|                                       LinearRegSlope_V1_Sign.mq5 | 
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//|                                                                  |
//|                         Modified from LinearRegSlope_v1 by Toshi |
//|                                  http://toshi52583.blogspot.com/ |
//+------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh                  |
//|    : __\MQL5\Include  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"
//----   
#property version   "1.11"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "LinearRegSlope_V1 Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "LinearRegSlope_V1 Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method SlMethod=MODE_SMA; // 
input int SlLength=12; //                     
input int SlPhase=15; // ,
                      // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;// 
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input uint TriggerShift=1; // c    
//+----------------------------------------------+

//----      
int min_rates_total;
//----   ,    
//      
double SellBuffer[],BuyBuffer[];
//----   
int TriggerShift_;
double Num2,SumBars;
//----   ,    
//      
int Count1[],Count2[];
double Smooth[],RegSlope[];
//----      
int ATR_Handle;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos1
(
 int &CoArr[],//        
 int Size //     
 )
// Recount_ArrayZeroPos(count, SlLength)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos2
(
 int &CoArr[],//        
 int Size //     
 )
// Recount_ArrayZeroPos(count, SlLength)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=GetStartBars(SlMethod,SlLength,SlPhase);
   min_rates_total=int(MathMax(ATR_Period,min_rates_total))+1;
   
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----       
   XMA1.XMALengthCheck("SlLength", SlLength);
   XMA1.XMAPhaseCheck("SlPhase", SlPhase, SlMethod);

//----     
   SumBars=SlLength *(SlLength-1)*0.5;
   double SumSqrBars=(SlLength-1.0)*SlLength *(2.0*SlLength-1.0)/6.0;
   Num2=SumBars*SumBars-SlLength*SumSqrBars;
   TriggerShift_=int(min_rates_total+TriggerShift-1);

//----       
   ArrayResize(Count1,SlLength);
   ArrayResize(Smooth,SlLength);
   ArrayResize(Count2,TriggerShift+1);
   ArrayResize(RegSlope,TriggerShift+1);

//----   
   ArrayInitialize(Count1,0);
   ArrayInitialize(Count2,0);
   ArrayInitialize(Smooth,0.0);
   ArrayInitialize(RegSlope,0.0);

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(SlMethod);
   StringConcatenate(shortname,"Linear Reg Slope(",SlLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----       
   double price,Sum1,Sum2,SumY,Num1,ATR[1],Trigger,trend;
   static double trend_;
//----        
   int first,bar,iii;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      trend_=0.0;
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price=PriceSeries(IPC,bar,open,low,high,close);
      Smooth[Count1[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,SlMethod,SlPhase,SlLength,price,bar,false);
      //----
      Sum1=0;
      SumY=0;
      //----
      if(bar>SlLength)
         for(iii=0; iii<SlLength; iii++)
           {
            SumY+=Smooth[Count1[iii]];
            Sum1+=iii*Smooth[Count1[iii]];
           }
      //----
      Sum2=SumBars*SumY;
      Num1=SlLength*Sum1-Sum2;
      //----
      if(Num2) RegSlope[Count2[0]]=100*Num1/Num2;
      else     RegSlope[Count2[0]]=EMPTY_VALUE;
      //----
      if(bar>TriggerShift_) Trigger=RegSlope[Count2[TriggerShift]];
      else                  Trigger=EMPTY_VALUE;
      //----   
      trend=RegSlope[Count2[0]]-Trigger;
      //----
      SellBuffer[bar]=0.0;
      BuyBuffer[bar]=0.0;
      //----
      if(trend_<=0 && trend>0)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //----
      if(trend_>=0 && trend<0)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //----
      if(bar<rates_total-1)
        {
         //----       Smooth[]
         Recount_ArrayZeroPos1(Count1,SlLength);
         //----       RegSlope[]
         Recount_ArrayZeroPos2(Count2,TriggerShift+1);
         //----   
         if(trend) trend_=trend;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
