//+------------------------------------------------------------------+
//|                                                  dynamix_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//---     
#property indicator_separate_window
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "dynamix"                     //    
#define SIZE 27                                      //      CountIndicator
//+-----------------------------------+
#property description "dynamix",SIZE
//----   
#property indicator_buffers SIZE 
//----    
#property indicator_plots   SIZE

//+-----------------------------------+
//|      |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----  -  
#property indicator_style1 STYLE_SOLID
//----   2
#property indicator_width1 2
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //   
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint step=10; //   ,    -  1  10
input Applied_price_ IPC=PRICE_CLOSE;// 
input int Shift=0; //      
input int ColorWidth=40; //   (  0  131)
//+-----------------------------------+
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                   |
//+------------------------------------------------------------------+  
class CIndicatorsBuffers
  {
public: double    IndBuffer[];
  };
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
CIndicatorsBuffers Ind[SIZE];
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
   
//----    dynamix
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME,step,IPC,0,40);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      "+INDICATOR_NAME);
      return(INIT_FAILED);
     }

//----     
   min_rates_total=2;

   color ArrayColors[]=
     {
      //---- 
      Black,DarkGreen,DarkSlateGray,Olive,Green,Teal,Navy,Purple,Maroon,Indigo,MidnightBlue,DarkBlue,
      DarkOliveGreen,SaddleBrown,ForestGreen,OliveDrab,SeaGreen,DarkGoldenrod,DarkSlateBlue,Sienna,MediumBlue,
      Brown,DarkTurquoise,DimGray,LightSeaGreen,DarkViolet,FireBrick,MediumVioletRed,MediumSeaGreen,Chocolate,
      Crimson,SteelBlue,Goldenrod,MediumSpringGreen,LawnGreen,CadetBlue,DarkOrchid,YellowGreen,LimeGreen,OrangeRed,
      DarkOrange,Orange,Gold,Yellow,Chartreuse,Lime,SpringGreen,Aqua,DeepSkyBlue,Blue,Magenta,Red,Gray,
      SlateGray,Peru,BlueViolet,LightSlateGray,DeepPink,MediumTurquoise,DodgerBlue,Turquoise,RoyalBlue,SlateBlue,
      DarkKhaki,IndianRed,MediumOrchid,GreenYellow,MediumAquamarine,DarkSeaGreen,Tomato,RosyBrown,Orchid,MediumPurple,
      PaleVioletRed,Coral,CornflowerBlue,DarkGray,SandyBrown,MediumSlateBlue,Tan,DarkSalmon,BurlyWood,HotPink,Salmon,
      Violet,LightCoral,SkyBlue,LightSalmon,Plum,Khaki,LightGreen,Aquamarine,Silver,LightSkyBlue,LightSteelBlue,
      LightBlue,PaleGreen,Thistle,PowderBlue,PaleGoldenrod,PaleTurquoise,LightGray,Wheat,NavajoWhite,Moccasin,LightPink,
      Gainsboro,PeachPuff,Pink,Bisque,LightGoldenrod,BlanchedAlmond,LemonChiffon,Beige,AntiqueWhite,PapayaWhip,Cornsilk,
      LightYellow,LightCyan,Linen,Lavender,MistyRose,OldLace,WhiteSmoke,Seashell,Ivory,Honeydew,AliceBlue,
      LavenderBlush,MintCream,Snow,White
      //---- 
     };

   int size=ArraySize(ArrayColors);
   size-=2;
   int ColorWidth_=ColorWidth;
   if(ColorWidth>size) ColorWidth_=size;
   if(ColorWidth<1) ColorWidth_=1;

   color Colors[];

   if(ArrayResize(Colors,ColorWidth_)<ColorWidth_) Print("      Colors");
   ArrayCopy(Colors,ArrayColors,0,2,ColorWidth_);

//----          
   ArraySetAsSeries(Colors,true);

   double K=double(ColorWidth_/(SIZE*1.0));
//----
   for(int numb=0; numb<SIZE; numb++)
     {
      string shortname="";
      StringConcatenate(shortname,"dynamix",numb);
      //---           
      PlotIndexSetString(numb,PLOT_LABEL,shortname);
      //----   ,      
      PlotIndexSetDouble(numb,PLOT_EMPTY_VALUE,EMPTY_VALUE);
      //----      
      PlotIndexSetInteger(numb,PLOT_DRAW_BEGIN,min_rates_total);
      //----      
      SetIndexBuffer(numb,Ind[numb].IndBuffer,INDICATOR_DATA);
      //----          
      ArraySetAsSeries(Ind[numb].IndBuffer,true);
      //----        
      PlotIndexSetInteger(numb,PLOT_DRAW_TYPE,PlotIndexGetInteger(0,PLOT_DRAW_TYPE));
      PlotIndexSetInteger(numb,PLOT_LINE_STYLE,PlotIndexGetInteger(0,PLOT_LINE_STYLE));
      PlotIndexSetInteger(numb,PLOT_LINE_WIDTH,PlotIndexGetInteger(0,PLOT_LINE_WIDTH));
      //----    
      PlotIndexSetInteger(numb,PLOT_LINE_COLOR,Colors[int(numb*K)]);
     }

//----      
   string shortname;
   StringConcatenate(shortname,"dynamix",SIZE,"(",step,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
   return(INIT_SUCCEEDED);
  }  
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----         
   ArraySetAsSeries(time,true); 
//----
   for(int numb=0; numb<SIZE; numb++) if(!CountIndicator(numb,NULL,TimeFrame,Ind_Handle,numb,Ind[numb].IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(
                    uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total //       
                    )
//---- 
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;

//----      
//  limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuf[bar]=0.0;

      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];

         //----      
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);

         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(
                     string IndName,
                     ENUM_TIMEFRAMES TFrame //  
                     )
//TimeFramesCheck(INDICATOR_NAME,TimeFrame)
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
