//+---------------------------------------------------------------------+ 
//|                                                            XKRI.mq5 | 
//|                                Copyright  2011,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrOrange
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "XKRI"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//----    Moving_Average   SmoothAlgorithms.mqh
CMoving_Average MA;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum ENUM_PRICE_TYPE // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint KRIPeriod=20; //  
input ENUM_MA_METHOD MA_Method_=MODE_SMA; //  
input double Ratio=1.0;
input ENUM_PRICE_TYPE IPC=PRICE_CLOSE_; //  
input Smooth_Method XMA_Method=MODE_JJMA; //  
input uint XLength=7; //  
input int XPhase=15;  //  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+
//----  
double KRIBuffer[];
//----      
int min_rates_1,min_rates_total;
//+------------------------------------------------------------------+    
//| XKRI indicator initialization function                           | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_1=int(KRIPeriod+1);
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase);
//----      
   SetIndexBuffer(0,KRIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"KRI");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"XKRI( KRIPeriod = ",KRIPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| XKRI iteration function                                          | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,KRI,mov;
//----   
   int first,bar;
//----    first    
   if(prev_calculated==0) //      
     {
      first=0; //      
     }
   else //      
     {
      first=prev_calculated-1;
     }
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     Series
      price=PriceSeries(IPC,bar,open,low,high,close);
      mov=MA.MASeries(0,prev_calculated,rates_total,KRIPeriod,MA_Method_,price,bar,false);
      KRI=100*(price-mov)/mov;
      KRIBuffer[bar]=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,KRI,bar,false);
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
