//+------------------------------------------------------------------+
//|                                         Exp_ColorZerolagJCCX.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+---------------------------------------------------+
//|                                  |
//+---------------------------------------------------+
#include <TradeAlgorithms.mqh>
//+---------------------------------------------------+
//|                 |
//+---------------------------------------------------+
input double MM=0.1;              //       
input MarginMode MMMode=LOT;      //    
input int    StopLoss_=1000;      //   
input int    TakeProfit_=2000;    //   
input int    Deviation_=10;       // .    
input bool   BuyPosOpen=true;     //      
input bool   SellPosOpen=true;    //      
input bool   BuyPosClose=true;    //      
input bool   SellPosClose=true;   //      
//+--------------------------------------------------+
//|                            |
//+--------------------------------------------------+
enum Applied_price_      //  
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price 
  };
//+--------------------------------------------------+
//|                     |
//+--------------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H4; //  
input uint SignalBar=1; //      
input uint    smoothing=15;
input uint Smooth = 8;  //  JJMA 
input int JPhase = 100; //  JJMA 
//----    -100 ... +100,
//----     ;
input ENUM_APPLIED_PRICE IPC=PRICE_CLOSE; //  
//----
input double Factor1=0.05;
input uint    JCCX_period1=8;
//----
input double Factor2=0.10;
input uint    JCCX_period2=21;
//----
input double Factor3=0.16;
input uint    JCCX_period3=34;
//----
input double Factor4=0.26;
input int    JCCX_period4=55;
//----
input double Factor5=0.43;
input uint    JCCX_period5=89;
//+--------------------------------------------------+
//----          
int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    ColorZerolagJCCX
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"ColorZerolagJCCX",
                         smoothing,Smooth,JPhase,IPC,Factor1,JCCX_period1,Factor2,JCCX_period2,
                         Factor3,JCCX_period3,Factor4,JCCX_period4,Factor5,JCCX_period5);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("     ColorZerolagJCCX");
      return(INIT_FAILED);
     }
//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);
//----     
   min_rates_total=int(3*32)+2;
   min_rates_total+=int(1+2+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;
//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);
//----   
   double Osc1[2],Osc2[2];
//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;
//----    
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;
      //----      
      if(CopyBuffer(InpInd_Handle,0,SignalBar,2,Osc1)<=0) {Recount=true; return;}
      if(CopyBuffer(InpInd_Handle,1,SignalBar,2,Osc2)<=0) {Recount=true; return;}
      //----    
      if(Osc1[1]>Osc2[1])
        {
         if(BuyPosOpen && Osc1[0]<Osc2[0]) BUY_Open=true;
         if(SellPosClose) SELL_Close=true;
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
      //----    
      if(Osc1[1]<Osc2[1])
        {
         if(SellPosOpen && Osc1[0]>Osc2[0]) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
     }
//----  
//----   
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);
//----   
   SellPositionClose(SELL_Close,Symbol(),Deviation_);
//----   
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----   
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
  }
//+------------------------------------------------------------------+
