//+------------------------------------------------------------------+
//|                                                         Flat.mq5 |
//|                                                      Pedro Puado |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//----  
#property copyright "Pedro Puado"
//----    
#property link      "http://www.metaquotes.net" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrGray
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Line"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_COLOR_ARROW
//----     
#property indicator_color2  clrGray,clrBlue,clrMagenta,clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  3
#property indicator_width2  3
//----   
#property indicator_label2  "Arrows"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_WIDTH // 
  {
   w_1=0,  //1
   w_2,    //2
   w_3,    //3
   w_4,    //4
   w_5     //5
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Smooth=10; //  
input ENUM_MA_METHOD      ma_method=MODE_SMA; //  
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE; //  
input uint HLRef=100;
input int Shift=0; //      
input uint ExtraHighLevel=60; //   
input uint HighLevel=40; //   
input uint LowLevel=20; //   
input ENUM_LINE_STYLE LevelStyle=STYLE_DASHDOTDOT; //   
input color LevelColor=clrBlue; //  
input ENUM_WIDTH LevelWidth=w_1; //  
//+----------------------------------------------+
//----   ,    
//----      
double Ind1Buffer[];
double Ind2Buffer[];
double ColorInd2Buffer[];
//----      
int Ind_Handle;
//----      
int min_rates_total;
//----   
int Count[];
double Value[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=int(2*Smooth);
//----    iStdDev
   Ind_Handle=iStdDev(NULL,0,Smooth,0,ma_method,applied_price);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iStdDev");
      return(INIT_FAILED);
     }
//----       
   ArrayResize(Count,HLRef);
   ArrayResize(Value,HLRef);
//----
   ArrayInitialize(Count,0);
   ArrayInitialize(Value,0.0);
//----       
   ArraySetAsSeries(Value,true);
//----      
   SetIndexBuffer(0,Ind1Buffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(Ind1Buffer,true);
//----      
   SetIndexBuffer(1,Ind2Buffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(Ind2Buffer,true);
//----     ,     
   SetIndexBuffer(2,ColorInd2Buffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorInd2Buffer,true);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   string shortname;
   StringConcatenate(shortname,"Flat( ",Smooth,", ",HLRef,", ",Shift," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----    
   IndicatorSetInteger(INDICATOR_LEVELS,3);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,ExtraHighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,HighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,LowLevel);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,LevelWidth);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double& High[],     //       
                const double& Low[],      //        
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar;
   double Std[],Sum,sStd,HH,LL,Range;
//----         
   ArraySetAsSeries(Std,true);
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=int(rates_total-1-Smooth);   //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=int(limit+1+Smooth);
//----      
   if(CopyBuffer(Ind_Handle,0,0,to_copy,Std)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Sum=0;
      for(int iii=0; iii<int(Smooth); iii++) Sum+=Std[bar+iii];
      sStd=Sum/Smooth;
      //----
      Sum=0;
      for(int iii=0; iii<int(Smooth); iii++) Sum+=MathAbs((Std[bar+iii]-sStd)*2);
      Value[Count[0]]=MathSqrt(Sum/Smooth);
      //----
      HH=Value[ArrayMaximum(Value,0,HLRef)];
      LL=Value[ArrayMinimum(Value,0,HLRef)];
      //----
      Range=HH-LL;
      if(Range) Ind1Buffer[bar]=100*(Value[Count[0]]-LL)/Range;
      else Ind1Buffer[bar]=100.0;
      Ind2Buffer[bar]=Ind1Buffer[bar];
      if(bar) Recount_ArrayZeroPos(Count,HLRef);
     }
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorInd2Buffer[bar]=1;
      if(Ind1Buffer[bar]>ExtraHighLevel) ColorInd2Buffer[bar]=3;
      else if(Ind1Buffer[bar]>HighLevel) ColorInd2Buffer[bar]=2;
      else if(Ind1Buffer[bar]<LowLevel)  ColorInd2Buffer[bar]=0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
