//+------------------------------------------------------------------+
//|                                                    FisherRVI.mq5 |
//|                                                                  |
//| Fisher RVI                                                       |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    Fisher RVI    |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  Red
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Fisher RVI"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  Blue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----   
#property indicator_label2  "Trigger"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Length=8; //  
input int Shift=0;  //      
//+----------------------------------------------+
//----   ,    
//----      
double FRVIBuffer[];
double TriggerBuffer[];
//----      
int min_rates_total;
//----   
int Count1[],Count2[];
double RVI[],Value1[],Value2[],Value3[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos1(int &CoArr[])//        
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max1=Length-1;
   Max2=Length;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos2(int &CoArr[])//        
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max1=3;
   Max2=4;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=Length+3;
//----       
   ArrayResize(Count1,Length);
   ArrayResize(Value1,Length);
   ArrayResize(Value2,Length);
   ArrayResize(RVI,Length);
   ArrayResize(Count2,4);
   ArrayResize(Value3,4);
//----      
   SetIndexBuffer(0,FRVIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total+1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//----      
   string shortname;
   StringConcatenate(shortname,"Fisher RVI(",Length,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double Num,Denom,hh,ll,tmp,rvi,Value4;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=3; //      
      for(int numb=0; numb<Length; numb++) Count1[numb]=numb;
      for(int numb=0; numb<4; numb++) Count2[numb]=numb;
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      Value1[Count1[0]]=((close[bar]-open[bar])+
                         2.0 *(close[bar-1]-open[bar-1])+
                         2.0 *(close[bar-2] - open[bar-2]) +
                         (close[bar-3]-open[bar-3]))/6.0;
      //----
      Value2[Count1[0]]=((high[bar]-low[bar])+
                         2.0 * (high[bar-1] - low[bar-1]) +
                         2.0 * (high[bar-2] - low[bar-2]) +
                         (high[bar-3]-low[bar-3]))/6.0;
      //----
      if(bar<Length+4)
        {
         Recount_ArrayZeroPos1(Count1);
         Recount_ArrayZeroPos2(Count2);
         continue;
        }
      //----
      Num=0.0;
      Denom=0.0;
      //----
      for(int iii=0; iii<Length; iii++)
        {
         Num+=Value1[Count1[iii]];
         Denom+=Value2[Count1[iii]];
        }
      //----
      if(Denom!=0.0) rvi=Num/Denom;
      else rvi=0.0;
      //----
      RVI[Count1[0]]=rvi;
      hh = rvi;
      ll = rvi;
      //----
      for(int iii=0; iii<Length; iii++)
        {
         tmp= RVI[Count1[iii]];
         hh = MathMax(hh, tmp);
         ll = MathMin(ll, tmp);
        }
      //----
      if(hh!=ll) Value3[Count2[0]]=(rvi-ll)/(hh-ll);
      else Value3[Count2[0]]=0.0;
      //----
      Value4=(4.0*Value3[Count2[0]]+3.0*Value3[Count2[1]]+2.0*Value3[Count2[2]]+Value3[Count2[3]])/10.0;
      //----
      double res=1.0-1.98 *(Value4-0.5);
      if(res) FRVIBuffer[bar]=0.5*MathLog((1.0+1.98 *(Value4-0.5))/res);
      else FRVIBuffer[bar]=0.0;
      //----
      TriggerBuffer[bar]=FRVIBuffer[bar-1];
      //----
      if(bar<rates_total-1)
        {
         Recount_ArrayZeroPos1(Count1);
         Recount_ArrayZeroPos2(Count2);
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
