//+------------------------------------------------------------------+ 
//|                                                 CCIBands_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
#property description " CCIBands       "
//----     
#property indicator_separate_window 
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "CCIBands"                    //    
#define SIZE 1                                       //      CountIndicator
#define INDTOTAL 3                                   //     
//+----------------------------------------------+
//----   
#property indicator_buffers INDTOTAL 
//----     
#property indicator_plots   INDTOTAL
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       Lime 
#property indicator_color1 clrLime
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "UpCCI"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       BlueViolet 
#property indicator_color2 clrBlueViolet
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "MediumCCI"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       Red 
#property indicator_color3 clrRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//----   
#property indicator_label3  "LowCCI"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +100.0
#property indicator_level2    0.0
#property indicator_level3 -100.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //   
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint CCIPeriod=14;                 //  CCI 
input double koeff=0.015;
input int XPhase=15;                     //  
//----  JJMA    -100 ... +100,     
//----  VIDIA   CMO,  AMA    
input int Shift=0;                         //          
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[];
double ColorIndBuffer[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
public:
   double            m_LineBuffer[];
  };
//---   ,   
//---      
CIndBuffers Ind[INDTOTAL];
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//----   
   min_rates_total=2;
   Symbol_=NULL;
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    CCIBands
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME,XMA_Method,CCIPeriod,koeff,XPhase);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      CCIBands");
      return(INIT_FAILED);
     }
//----   
   for(int count=0; count<INDTOTAL; count++) IndInit(count,Ind[count].m_LineBuffer,EMPTY_VALUE,min_rates_total,Shift);
//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----         
   ArraySetAsSeries(time,true);
//----
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//----
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
//----        
   PlotIndexSetInteger(Number,PLOT_DRAW_TYPE,DRAW_LINE);
//----   
   PlotIndexSetString(Number,PLOT_LABEL,"Line "+string(Number+1));
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//----      
//----   limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      for(int count=0; count<INDTOTAL; count++) Ind[count].m_LineBuffer[bar]=EMPTY_VALUE;
      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         //---
         for(int count=0; count<INDTOTAL; count++)
           {
            double Arr[1];
            //----      
            if(CopyBuffer(IndHandle,count,iTime[bar],1,Arr)<=0) return(RESET);
            Ind[count].m_LineBuffer[bar]=Arr[0];
           }
        }
      else for(int count=0; count<INDTOTAL; count++) Ind[count].m_LineBuffer[bar]=Ind[count].m_LineBuffer[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //  
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
