//+------------------------------------------------------------------+ 
//|                                                          CMx.mq5 | 
//|                                       Copyright  2005, Alexandr | 
//|                                              beluck[at]gmail.com | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Copyright  2005, Alexandr"
//---  
#property link      ""
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        LimeGreen 
#property indicator_color1  clrLimeGreen
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "CMx"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int    F=12;
input double k=1.682;
input double L_adx=18;
input int    Shift=0;            //      
input double Level1=+423.6;      //  1
input double Level2=+261.8;      //  2
input double Level3=+161.8;      //  3
input double Level4=+61.8;       //  4
input double Level5=0.0;         //  5
input double Level6=-61.8;       //  6
input double Level7=-161.8;      //  7
input double Level8=-261.8;      //  8
input double Level9=-423.6;      //  9
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---
double L_adxk;
//---      
int MA1_Handle,MA2_Handle,Ind_Handle,ADX_Handle,CCI_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   int Fk=int(MathRound(MathAbs(F*k)));
   min_rates_total=int(MathMax(F,Fk));
   if(F>0) min_rates_total*=2;
//--- 
   if(F<0)
     {
      //---    iMA 1
      MA1_Handle=iMA(Symbol(),PERIOD_CURRENT,-F,0,MODE_EMA,PRICE_CLOSE);
      if(MA1_Handle==INVALID_HANDLE)
        {
         Print("     iMA 1");
         return(INIT_FAILED);
        }
      //---    iMA 2
      MA2_Handle=iMA(Symbol(),PERIOD_CURRENT,Fk,0,MODE_EMA,PRICE_CLOSE);
      if(MA2_Handle==INVALID_HANDLE)
        {
         Print("     iMA 2");
         return(INIT_FAILED);
        }
     }
   else if(F>0)
     {
      L_adxk=L_adx*k;
      string IndName=MQLInfoString(MQL_PROGRAM_NAME);
      //----    CMx
      Ind_Handle=iCustom(Symbol(),PERIOD_CURRENT,IndName,-F,k,L_adx,0);
      if(Ind_Handle==INVALID_HANDLE)
        {
         Print("     CMx");
         return(INIT_FAILED);
        }
      //---    iCCI
      CCI_Handle=iCCI(Symbol(),PERIOD_CURRENT,Fk,Ind_Handle);
      if(CCI_Handle==INVALID_HANDLE)
        {
         Print("     iCCI");
         return(INIT_FAILED);
        }
      //---    iADX
      ADX_Handle=iADX(Symbol(),PERIOD_CURRENT,F);
      if(ADX_Handle==INVALID_HANDLE)
        {
         Print("     iADX");
         return(INIT_FAILED);
        }
     }
   else
     {
      Print("      !");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---        min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"CMx(",F,", ",DoubleToString(k,4),", ",DoubleToString(L_adx,2),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---      9   
   IndicatorSetInteger(INDICATOR_LEVELS,9);
//---       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,Level1);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,Level2);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,Level3);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,3,Level4);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,4,Level5);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,5,Level6);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,6,Level7);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,7,Level8);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,8,Level9);
//---             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,4,clrGray);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,5,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,6,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,7,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,8,clrBlue);
//---       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,4,STYLE_DASH);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,5,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,6,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,7,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,8,STYLE_DASHDOTDOT);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---
   if(F<0)
     {
      if(BarsCalculated(MA1_Handle)<rates_total
         || BarsCalculated(MA2_Handle)<rates_total) return(RESET);
     }
   else
     {
      if(BarsCalculated(Ind_Handle)<rates_total
         || BarsCalculated(ADX_Handle)<rates_total
         || BarsCalculated(CCI_Handle)<rates_total) return(RESET);
     }
//---    
   int to_copy,limit,bar;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else limit=rates_total-prev_calculated; //      
//---   
   to_copy=limit+1;
//---
   if(F<0)
     {
      double Ma1[],Ma2[];
      //---         
      ArraySetAsSeries(Ma1,true);
      ArraySetAsSeries(Ma2,true);
      //---      
      if(CopyBuffer(MA1_Handle,0,0,to_copy,Ma1)<=0) return(RESET);
      if(CopyBuffer(MA2_Handle,0,0,to_copy,Ma2)<=0) return(RESET);
      //---    
      for(bar=limit; bar>=0 && !IsStopped(); bar--) IndBuffer[bar]=Ma1[bar]-Ma2[bar];
     }
   else
     {
      double CCI[],ADX[];
      //---         
      ArraySetAsSeries(CCI,true);
      ArraySetAsSeries(ADX,true);
      //---      
      if(CopyBuffer(CCI_Handle,0,0,to_copy,CCI)<=0) return(RESET);
      if(CopyBuffer(ADX_Handle,0,0,to_copy,ADX)<=0) return(RESET);
      //---    
      for(bar=limit; bar>=0 && !IsStopped(); bar--) IndBuffer[bar]=CCI[bar]*ADX[bar]/L_adxk;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
